/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S2201")
public class IgnoredReturnValueCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final List<String> CHECKED_TYPES = ImmutableList.builder().add((Object)"java.lang.String").add((Object)"java.lang.Boolean").add((Object)"java.lang.Integer").add((Object)"java.lang.Double").add((Object)"java.lang.Float").add((Object)"java.lang.Byte").add((Object)"java.lang.Character").add((Object)"java.lang.Short").add((Object)"java.lang.StackTraceElement").add((Object)"java.time.DayOfWeek").add((Object)"java.time.Duration").add((Object)"java.time.Instant").add((Object)"java.time.LocalDate").add((Object)"java.time.LocalDateTime").add((Object)"java.time.LocalTime").add((Object)"java.time.Month").add((Object)"java.time.MonthDay").add((Object)"java.time.OffsetDateTime").add((Object)"java.time.OffsetTime").add((Object)"java.time.Period").add((Object)"java.time.Year").add((Object)"java.time.YearMonth").add((Object)"java.time.ZonedDateTime").add((Object)"java.math.BigInteger").add((Object)"java.math.BigDecimal").add((Object)"java.util.Optional").build();
    private static final Set<String> EXCLUDED_PREFIX = ImmutableSet.of((Object)"parse", (Object)"format", (Object)"decode", (Object)"valueOf");
    private static final MethodMatcherCollection EXCLUDED = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.lang.Character").name("toChars").parameters(new String[]{"int", "char[]", "int"}), MethodMatcher.create().typeDefinition("java.lang.String").name("intern").withoutParameter()});
    private static final MethodMatcher STRING_GET_BYTES = MethodMatcher.create().typeDefinition("java.lang.String").name("getBytes").parameters(new String[]{"java.nio.charset.Charset"});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ExpressionTree expr = ((ExpressionStatementTree)tree).expression();
        if (expr.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)expr;
            if (IgnoredReturnValueCheck.isExcluded(mit)) {
                return;
            }
            Symbol methodSymbol = mit.symbol();
            if (!IgnoredReturnValueCheck.isVoidOrUnknown(mit.symbolType()) && IgnoredReturnValueCheck.isCheckedType(methodSymbol.owner().type()) && methodSymbol.isPublic() && !IgnoredReturnValueCheck.isConstructor(methodSymbol)) {
                IdentifierTree methodName = ExpressionUtils.methodName((MethodInvocationTree)mit);
                this.reportIssue((Tree)methodName, "The return value of \"" + methodName.name() + "\" must be used.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isExcluded(MethodInvocationTree mit) {
        String methodName = mit.symbol().name();
        if (mit.symbol().isUnknown()) return true;
        if (EXCLUDED.anyMatch(mit)) return true;
        if (!IgnoredReturnValueCheck.isInTryCatch(mit)) return false;
        if (EXCLUDED_PREFIX.stream().anyMatch(methodName::startsWith)) return true;
        if (!STRING_GET_BYTES.matches(mit)) return false;
        return true;
    }

    private static boolean isInTryCatch(MethodInvocationTree mit) {
        Tree parent;
        for (parent = mit.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT}); parent = parent.parent()) {
        }
        return parent != null && !((TryStatementTree)parent).catches().isEmpty();
    }

    private static boolean isCheckedType(Type ownerType) {
        return CHECKED_TYPES.stream().anyMatch(arg_0 -> ((Type)ownerType).is(arg_0));
    }

    private static boolean isVoidOrUnknown(Type methodType) {
        return methodType.isVoid() || methodType.isUnknown();
    }

    private static boolean isConstructor(Symbol methodSymbol) {
        return ((JavaSymbol.MethodJavaSymbol)methodSymbol).isConstructor();
    }
}

