/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.resolve.MethodJavaType;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S00112")
@RspecKey(value="S112")
public class RawExceptionCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Set<String> RAW_EXCEPTIONS = ImmutableSet.of((Object)"java.lang.Throwable", (Object)"java.lang.Error", (Object)"java.lang.Exception", (Object)"java.lang.RuntimeException");
    private JavaFileScannerContext context;
    private Set<Type> exceptionsThrownByMethodInvocations = new HashSet<Type>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        super.visitMethod(tree);
        if ((tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) || RawExceptionCheck.isNotOverridden(tree)) && RawExceptionCheck.isNotMainMethod(tree)) {
            for (TypeTree throwClause : tree.throwsClauses()) {
                Type exceptionType = throwClause.symbolType();
                if (!RawExceptionCheck.isRawException(exceptionType) || this.exceptionsThrownByMethodInvocations.contains(exceptionType)) continue;
                this.reportIssue((Tree)throwClause);
            }
        }
        this.exceptionsThrownByMethodInvocations.clear();
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        if (tree.expression().is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            TypeTree exception = ((NewClassTree)tree.expression()).identifier();
            Type symbolType = exception.symbolType();
            if (symbolType instanceof MethodJavaType) {
                symbolType = ((MethodJavaType)exception.symbolType()).resultType();
            }
            if (RawExceptionCheck.isRawException(symbolType)) {
                this.reportIssue((Tree)exception);
            }
        }
        super.visitThrowStatement(tree);
    }

    private void reportIssue(Tree tree) {
        this.context.reportIssue((JavaCheck)this, tree, "Define and throw a dedicated exception instead of using a generic one.");
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        if (tree.symbol().isMethodSymbol()) {
            for (Type thrownType : ((Symbol.MethodSymbol)tree.symbol()).thrownTypes()) {
                this.exceptionsThrownByMethodInvocations.add(thrownType);
            }
        }
        super.visitMethodInvocation(tree);
    }

    private static boolean isRawException(Type type) {
        for (String rawException : RAW_EXCEPTIONS) {
            if (!type.is(rawException)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotOverridden(MethodTree tree) {
        return Boolean.FALSE.equals(tree.isOverriding());
    }

    private static boolean isNotMainMethod(MethodTree tree) {
        return !MethodTreeUtils.isMainMethod(tree);
    }
}

