/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2109")
public class ReflectionOnNonRuntimeAnnotationCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.lang.reflect.AnnotatedElement")).name("isAnnotationPresent").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Type symbolType;
        ExpressionTree expressionTree = (ExpressionTree)mit.arguments().get(0);
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && !(symbolType = ((MemberSelectExpressionTree)expressionTree).expression().symbolType()).isUnknown() && ReflectionOnNonRuntimeAnnotationCheck.isNotRuntimeAnnotation(symbolType)) {
            this.reportIssue((Tree)expressionTree, "\"@" + symbolType.name() + "\" is not available at runtime and cannot be seen with reflection.");
        }
    }

    private static boolean isNotRuntimeAnnotation(Type symbolType) {
        List valuesFor = symbolType.symbol().metadata().valuesForAnnotation("java.lang.annotation.Retention");
        if (valuesFor == null) {
            return true;
        }
        String retentionValue = ReflectionOnNonRuntimeAnnotationCheck.getRetentionValue(((SymbolMetadata.AnnotationValue)valuesFor.get(0)).value());
        return !"RUNTIME".equals(retentionValue);
    }

    @Nullable
    private static String getRetentionValue(Object value) {
        String retentionValue = null;
        if (value instanceof Tree) {
            Tree tree = (Tree)value;
            if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                retentionValue = ((MemberSelectExpressionTree)tree).identifier().name();
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                retentionValue = ((IdentifierTree)tree).name();
            }
        } else if (value instanceof Symbol.VariableSymbol) {
            retentionValue = ((Symbol.VariableSymbol)value).name();
        }
        return retentionValue;
    }
}

