/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S1989")
public class ServletMethodsExceptionsThrownCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcher IS_SERVLET_DO_METHOD = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"javax.servlet.http.HttpServlet")).name(NameCriteria.startsWith((String)"do")).withAnyParameters();
    private final Deque<Boolean> shouldCheck = new ArrayDeque<Boolean>();
    private final Deque<List<Type>> tryCatches = new ArrayDeque<List<Type>>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.THROW_STATEMENT, Tree.Kind.METHOD_INVOCATION, Tree.Kind.TRY_STATEMENT, Tree.Kind.CATCH);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.shouldCheck.push(IS_SERVLET_DO_METHOD.matches((MethodTree)tree));
        } else if (this.shouldCheck()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT})) {
                this.tryCatches.add(ServletMethodsExceptionsThrownCheck.getCatchedExceptions(((TryStatementTree)tree).catches()));
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.CATCH})) {
                this.tryCatches.pop();
                this.tryCatches.add(Collections.emptyList());
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT})) {
                this.addIssueIfNotCatched(Collections.singletonList(((ThrowStatementTree)tree).expression().symbolType()), tree, "Add a \"try/catch\" block.");
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.checkMethodInvocation((MethodInvocationTree)tree);
            }
        }
    }

    private boolean shouldCheck() {
        return !this.shouldCheck.isEmpty() && this.shouldCheck.peek() != false;
    }

    public void leaveNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.shouldCheck.pop();
        } else if (this.shouldCheck() && tree.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT})) {
            this.tryCatches.pop();
        }
    }

    private static List<Type> getCatchedExceptions(List<CatchTree> catches) {
        ArrayList<Type> result = new ArrayList<Type>();
        for (CatchTree element : catches) {
            result.add(element.parameter().type().symbolType());
        }
        return result;
    }

    private void checkMethodInvocation(MethodInvocationTree node) {
        List types;
        Symbol symbol = node.symbol();
        if (symbol.isMethodSymbol() && !(types = ((Symbol.MethodSymbol)symbol).thrownTypes()).isEmpty()) {
            this.addIssueIfNotCatched(types, (Tree)ExpressionUtils.methodName((MethodInvocationTree)node), "Add a \"try/catch\" block for \"" + symbol.name() + "\".");
        }
    }

    private void addIssueIfNotCatched(Iterable<Type> thrown, Tree node, String message) {
        for (Type type : thrown) {
            if (!this.isNotcatched(type)) continue;
            this.reportIssue(node, message);
        }
    }

    private boolean isNotcatched(Type type) {
        for (List<Type> tryCatch : this.tryCatches) {
            for (Type tryCatchType : tryCatch) {
                if (!type.isSubtypeOf(tryCatchType)) continue;
                return false;
            }
        }
        return true;
    }
}

