/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1860")
public class SynchronizationOnStringOrBoxedCheck
extends IssuableSubscriptionVisitor {
    private static final List<String> FORBIDDEN_TYPES = ImmutableList.of((Object)Boolean.class.getName(), (Object)Byte.class.getName(), (Object)Character.class.getName(), (Object)Double.class.getName(), (Object)Float.class.getName(), (Object)Integer.class.getName(), (Object)Long.class.getName(), (Object)Short.class.getName(), (Object)String.class.getName());

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.SYNCHRONIZED_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SynchronizedStatementTree syncStatement = (SynchronizedStatementTree)tree;
        Type expressionType = syncStatement.expression().symbolType();
        if (expressionType.isPrimitive() || SynchronizationOnStringOrBoxedCheck.isForbiddenType(expressionType)) {
            this.reportIssue((Tree)syncStatement.expression(), "Synchronize on a new \"Object\" instead.");
        }
    }

    private static boolean isForbiddenType(Type expressionType) {
        for (String forbiddenType : FORBIDDEN_TYPES) {
            if (!expressionType.is(forbiddenType)) continue;
            return true;
        }
        return false;
    }
}

