/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1844")
public class WaitOnConditionCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        TypeCriteria conditionSubType = TypeCriteria.subtypeOf((String)"java.util.concurrent.locks.Condition");
        return Arrays.asList(MethodMatcher.create().callSite(conditionSubType).name("wait").withoutParameter(), MethodMatcher.create().callSite(conditionSubType).name("wait").addParameter("long"), MethodMatcher.create().callSite(conditionSubType).name("wait").addParameter("long").addParameter("int"));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "The \"Condition.await(...)\" method should be used instead of \"Object.wait(...)\"");
    }

    @Override
    protected void onMethodReferenceFound(MethodReferenceTree methodReferenceTree) {
        this.reportIssue((Tree)methodReferenceTree.method(), "The \"Condition.await(...)\" method should be used instead of \"Object.wait(...)\"");
    }
}

