/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.checks.helpers.ReassignmentFinder;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

public class ExpressionsHelper {
    private ExpressionsHelper() {
    }

    public static String concatenate(@Nullable ExpressionTree tree) {
        if (tree == null) {
            return "";
        }
        LinkedList<String> pieces = new LinkedList<String>();
        ExpressionTree expr = tree;
        while (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
            pieces.push(mse.identifier().name());
            pieces.push(".");
            expr = mse.expression();
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree idt = (IdentifierTree)expr;
            pieces.push(idt.name());
        }
        StringBuilder sb = new StringBuilder();
        for (String piece : pieces) {
            sb.append(piece);
        }
        return sb.toString();
    }

    public static Tree reportOnClassTree(ClassTree classTree) {
        IdentifierTree reportTree = classTree.simpleName();
        if (reportTree == null) {
            reportTree = ((NewClassTree)classTree.parent()).identifier();
        }
        return reportTree;
    }

    public static ValueResolution getConstantValue(ExpressionTree expression) {
        return ExpressionsHelper.valueResolution(expression, ConstantUtils::resolveAsConstant, new ValueResolution());
    }

    public static ValueResolution<String> getConstantValueAsString(ExpressionTree expression) {
        return ExpressionsHelper.valueResolution(expression, ConstantUtils::resolveAsStringConstant, new ValueResolution());
    }

    public static ValueResolution<Boolean> getConstantValueAsBoolean(ExpressionTree expression) {
        return ExpressionsHelper.valueResolution(expression, ConstantUtils::resolveAsBooleanConstant, new ValueResolution());
    }

    private static <T> ValueResolution<T> valueResolution(ExpressionTree expression, Function<ExpressionTree, T> resolver, ValueResolution<T> valueResolution) {
        T value = resolver.apply(expression);
        if (value == null && expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            ExpressionTree singleWriteUsage = ExpressionsHelper.getSingleWriteUsage(((IdentifierTree)expression).symbol());
            if (singleWriteUsage == null || !ExpressionsHelper.isStrictAssignmentOrDeclaration(singleWriteUsage) || singleWriteUsage == expression) {
                value = null;
            } else {
                ((ValueResolution)valueResolution).addLocation(singleWriteUsage);
                return ExpressionsHelper.valueResolution(singleWriteUsage, resolver, valueResolution);
            }
        }
        ((ValueResolution)valueResolution).value = value;
        return valueResolution;
    }

    @CheckForNull
    private static ExpressionTree getSingleWriteUsage(Symbol symbol) {
        ExpressionTree initializerOrExpression = ReassignmentFinder.getInitializerOrExpression(symbol.declaration());
        List<AssignmentExpressionTree> reassignments = ReassignmentFinder.getReassignments(symbol.owner().declaration(), symbol.usages());
        if (initializerOrExpression == null && reassignments.size() == 1) {
            return reassignments.get(0).expression();
        }
        if (initializerOrExpression != null && reassignments.isEmpty()) {
            return initializerOrExpression;
        }
        return null;
    }

    private static boolean isStrictAssignmentOrDeclaration(ExpressionTree expression) {
        if (expression.parent() instanceof AssignmentExpressionTree) {
            return expression.parent().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT});
        }
        return true;
    }

    public static class ValueResolution<T> {
        private T value;
        private List<JavaFileScannerContext.Location> valuePath = new ArrayList<JavaFileScannerContext.Location>();

        private void addLocation(ExpressionTree expressionTree) {
            this.valuePath.add(new JavaFileScannerContext.Location("", (Tree)expressionTree));
        }

        @CheckForNull
        public T value() {
            return this.value;
        }

        public List<JavaFileScannerContext.Location> valuePath() {
            return this.valuePath;
        }
    }
}

