/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4434")
public class LDAPDeserializationCheck
extends AbstractMethodDetection {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String CLASS_NAME = "javax.naming.directory.SearchControls";
    private static final int RET_OBJ_INDEX = 4;

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)CLASS_NAME)).name(CONSTRUCTOR_NAME).withAnyParameters(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)CLASS_NAME)).name("setReturningObjFlag").parameters(new String[]{"boolean"}));
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.checkConstructorArguments(newClassTree.arguments());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree methodTree) {
        if (CONSTRUCTOR_NAME.equals(methodTree.symbol().name())) {
            this.checkConstructorArguments(methodTree.arguments());
        } else {
            ExpressionTree setValue = (ExpressionTree)methodTree.arguments().get(0);
            this.reportIfTrue(setValue);
        }
    }

    private void checkConstructorArguments(Arguments args) {
        if (args.size() <= 4) {
            return;
        }
        ExpressionTree retObjArgument = (ExpressionTree)args.get(4);
        this.reportIfTrue(retObjArgument);
    }

    private void reportIfTrue(ExpressionTree toUnderline) {
        if (LiteralUtils.isTrue((Tree)toUnderline)) {
            this.reportIssue((Tree)toUnderline, "Disable object deserialization.");
        }
    }
}

