/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3305")
public class SpringConfigurationWithAutowiredFieldsCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE_FORMAT = "Inject this field value directly into \"%s\", the only method that uses it.";
    private static final String CONFIGURATION_ANNOTATION = "org.springframework.context.annotation.Configuration";
    private static final String BEAN_ANNOTATION = "org.springframework.context.annotation.Bean";
    private static final List<String> AUTOWIRED_ANNOTATIONS = Arrays.asList("org.springframework.beans.factory.annotation.Autowired", "javax.inject.Inject");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.symbol().metadata().isAnnotatedWith(CONFIGURATION_ANNOTATION)) {
            HashMap autowiredFields = new HashMap();
            classTree.members().forEach(m -> SpringConfigurationWithAutowiredFieldsCheck.collectAutowiredFields(m, autowiredFields));
            HashMap methodsThatUseAutowiredFields = new HashMap();
            autowiredFields.keySet().forEach(f -> methodsThatUseAutowiredFields.put(f, new ArrayList()));
            classTree.members().forEach(m -> SpringConfigurationWithAutowiredFieldsCheck.collectMethodsThatUseAutowiredFields(m, methodsThatUseAutowiredFields));
            methodsThatUseAutowiredFields.entrySet().stream().filter(methodsForField -> ((List)methodsForField.getValue()).size() == 1 && ((MethodTree)((List)methodsForField.getValue()).get(0)).symbol().metadata().isAnnotatedWith(BEAN_ANNOTATION)).forEach(methodsForField -> this.reportIssue((Tree)((VariableTree)autowiredFields.get(methodsForField.getKey())).simpleName(), String.format(MESSAGE_FORMAT, ((MethodTree)((List)methodsForField.getValue()).get(0)).simpleName().name())));
        }
    }

    private static void collectAutowiredFields(Tree tree, Map<Symbol, VariableTree> autowiredFields) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return;
        }
        VariableTree variable = (VariableTree)tree;
        Symbol variableSymbol = variable.symbol();
        if (AUTOWIRED_ANNOTATIONS.stream().anyMatch(a -> variableSymbol.metadata().isAnnotatedWith(a))) {
            autowiredFields.put(variableSymbol, variable);
        }
    }

    private static void collectMethodsThatUseAutowiredFields(Tree tree, Map<Symbol, List<MethodTree>> methodsThatUseAutowiredFields) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            return;
        }
        IdentifiersVisitor identifiersVisitor = new IdentifiersVisitor(methodsThatUseAutowiredFields.keySet());
        tree.accept((TreeVisitor)identifiersVisitor);
        identifiersVisitor.isFieldReferenced.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).forEach(field -> ((List)methodsThatUseAutowiredFields.get(field)).add((MethodTree)tree));
    }

    private static class IdentifiersVisitor
    extends BaseTreeVisitor {
        private final Map<Symbol, Boolean> isFieldReferenced = new HashMap<Symbol, Boolean>();

        IdentifiersVisitor(Set<Symbol> autowiredFields) {
            autowiredFields.forEach(f -> this.isFieldReferenced.put((Symbol)f, false));
        }

        public void visitIdentifier(IdentifierTree identifierTree) {
            this.isFieldReferenced.computeIfPresent(identifierTree.symbol(), (fieldSym, isPresent) -> true);
        }
    }
}

