/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilterChain;
import org.sonar.java.filters.EclipseI18NFilter;
import org.sonar.java.filters.GeneratedCodeFilter;
import org.sonar.java.filters.JavaIssueFilter;
import org.sonar.java.filters.LombokFilter;
import org.sonar.java.filters.SonarJavaIssueFilter;
import org.sonar.java.filters.SuppressWarningFilter;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;

public class PostAnalysisIssueFilter
implements JavaFileScanner,
SonarJavaIssueFilter {
    private static final Iterable<JavaIssueFilter> DEFAULT_ISSUE_FILTERS = ImmutableList.of((Object)new EclipseI18NFilter(), (Object)new LombokFilter(), (Object)new SuppressWarningFilter(), (Object)new GeneratedCodeFilter());
    private Iterable<JavaIssueFilter> issueFilers;

    @VisibleForTesting
    void setIssueFilters(Iterable<? extends JavaIssueFilter> issueFilters) {
        this.issueFilers = ImmutableList.builder().addAll(issueFilters).build();
    }

    @VisibleForTesting
    Iterable<JavaIssueFilter> getIssueFilters() {
        if (this.issueFilers == null) {
            this.issueFilers = DEFAULT_ISSUE_FILTERS;
        }
        return this.issueFilers;
    }

    public boolean accept(FilterableIssue issue, IssueFilterChain chain) {
        for (JavaIssueFilter javaIssueFilter : this.getIssueFilters()) {
            if (javaIssueFilter.accept(issue)) continue;
            return false;
        }
        return chain.accept(issue);
    }

    public void scanFile(JavaFileScannerContext context) {
        for (JavaIssueFilter javaIssueFilter : this.getIssueFilters()) {
            javaIssueFilter.scanFile(context);
        }
    }
}

