/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractPrintfChecker
extends AbstractMethodDetection {
    protected static final String JAVA_LANG_STRING = "java.lang.String";
    protected static final String JAVA_UTIL_LOGGING_LOGGER = "java.util.logging.Logger";
    protected static final String ORG_APACHE_LOGGING_LOG4J_LOGGER = "org.apache.logging.log4j.Logger";
    protected static final String ORG_SLF4J_LOGGER = "org.slf4j.Logger";
    protected static final String JAVA_LANG_THROWABLE = "java.lang.Throwable";
    private static final Pattern PRINTF_PARAM_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private static final String PRINTF_METHOD_NAME = "printf";
    private static final String FORMAT_METHOD_NAME = "format";
    protected static final List<String> LEVELS = Arrays.asList("debug", "error", "info", "trace", "warn", "fatal");
    protected static final MethodMatchers MESSAGE_FORMAT = MethodMatchers.create().ofTypes(new String[]{"java.text.MessageFormat"}).names(new String[]{"format"}).withAnyParameters().build();
    protected static final MethodMatchers JAVA_UTIL_LOGGER_LOG_LEVEL_STRING = MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(new String[]{"log"}).addParametersMatcher(new String[]{"java.util.logging.Level", "java.lang.String"}).build();
    protected static final MethodMatchers JAVA_UTIL_LOGGER_LOG_LEVEL_STRING_ANY = MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(new String[]{"log"}).addParametersMatcher(new String[]{"java.util.logging.Level", "java.lang.String", "*"}).build();
    protected static final MethodMatchers JAVA_UTIL_LOGGER_LOG_MATCHER = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{JAVA_UTIL_LOGGER_LOG_LEVEL_STRING, JAVA_UTIL_LOGGER_LOG_LEVEL_STRING_ANY});
    protected static final Pattern MESSAGE_FORMAT_PATTERN = Pattern.compile("\\{(?<index>\\d+)(?<type>,\\w+)?(?<style>,[^}]*)?\\}");

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        ArrayList<MethodMatchers> matchers = new ArrayList<MethodMatchers>(AbstractPrintfChecker.slf4jMethods());
        matchers.add(AbstractPrintfChecker.log4jMethods());
        matchers.addAll(Arrays.asList(MethodMatchers.create().ofTypes(new String[]{JAVA_LANG_STRING}).names(new String[]{FORMAT_METHOD_NAME}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.Formatter"}).names(new String[]{FORMAT_METHOD_NAME}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.io.PrintStream"}).names(new String[]{FORMAT_METHOD_NAME, PRINTF_METHOD_NAME}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.io.PrintWriter"}).names(new String[]{FORMAT_METHOD_NAME, PRINTF_METHOD_NAME}).withAnyParameters().build(), MESSAGE_FORMAT, JAVA_UTIL_LOGGER_LOG_LEVEL_STRING, JAVA_UTIL_LOGGER_LOG_LEVEL_STRING_ANY));
        return MethodMatchers.or(matchers);
    }

    private static Collection<MethodMatchers> slf4jMethods() {
        return LEVELS.stream().map(l -> MethodMatchers.create().ofTypes(new String[]{ORG_SLF4J_LOGGER}).names(new String[]{l}).withAnyParameters().build()).collect(Collectors.toList());
    }

    private static MethodMatchers log4jMethods() {
        ArrayList<String> methodNames = new ArrayList<String>();
        methodNames.add(PRINTF_METHOD_NAME);
        methodNames.add("log");
        methodNames.addAll(LEVELS);
        return MethodMatchers.create().ofTypes(new String[]{ORG_APACHE_LOGGING_LOG4J_LOGGER}).names(methodNames.toArray(new String[0])).withAnyParameters().build();
    }

    protected final void checkFormatting(MethodInvocationTree mit, boolean isMessageFormat) {
        List args;
        ExpressionTree formatTree;
        Arguments arguments = mit.arguments();
        if (arguments.stream().map(ExpressionTree::symbolType).anyMatch(Type::isUnknown)) {
            return;
        }
        if (((ExpressionTree)arguments.get(0)).symbolType().is(JAVA_LANG_STRING)) {
            formatTree = (ExpressionTree)arguments.get(0);
            args = arguments.subList(1, arguments.size());
        } else {
            if (arguments.size() < 2) {
                return;
            }
            formatTree = (ExpressionTree)arguments.get(1);
            args = arguments.subList(2, arguments.size());
        }
        if (formatTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String formatString = LiteralUtils.trimQuotes((String)((LiteralTree)formatTree).value());
            if (isMessageFormat && AbstractPrintfChecker.isProbablyLog4jFormatterLogger(mit, formatString)) {
                isMessageFormat = false;
            }
            if (isMessageFormat) {
                this.handleMessageFormat(mit, formatString, args);
            } else {
                this.handlePrintfFormat(mit, formatString, args);
            }
        } else {
            this.handleOtherFormatTree(mit, formatTree, args);
        }
    }

    private static boolean isProbablyLog4jFormatterLogger(MethodInvocationTree mit, String formatString) {
        return mit.symbol().owner().type().is(ORG_APACHE_LOGGING_LOG4J_LOGGER) && !formatString.contains("{}") && formatString.contains("%");
    }

    protected abstract void handlePrintfFormat(MethodInvocationTree var1, String var2, List<ExpressionTree> var3);

    protected abstract void handleMessageFormat(MethodInvocationTree var1, String var2, List<ExpressionTree> var3);

    protected abstract void handleOtherFormatTree(MethodInvocationTree var1, ExpressionTree var2, List<ExpressionTree> var3);

    protected static boolean isNewArrayWithInitializers(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY}) && ((NewArrayTree)expression).openBraceToken() != null;
    }

    protected static String cleanupDoubleQuote(String formatString) {
        return formatString.replaceAll("''", "");
    }

    protected static Set<Integer> getMessageFormatIndexes(String formatString, MethodInvocationTree mit) {
        if (LEVELS.contains(mit.symbol().name()) || formatString.contains("{}")) {
            return IntStream.range(0, StringUtils.countMatches((String)formatString, (String)"{}")).boxed().collect(Collectors.toSet());
        }
        Matcher matcher = MESSAGE_FORMAT_PATTERN.matcher(formatString);
        HashSet<Integer> result = new HashSet<Integer>();
        while (matcher.find()) {
            if (!AbstractPrintfChecker.isMessageFormatPattern(formatString, matcher.start())) continue;
            result.add(Integer.parseInt(matcher.group("index")));
        }
        return result;
    }

    private static boolean isMessageFormatPattern(String formatString, int start) {
        return start == 0 || formatString.charAt(start - 1) != '\'' || StringUtils.countMatches((String)formatString.substring(0, start), (String)"'") % 2 == 0;
    }

    protected List<String> getParameters(String formatString, MethodInvocationTree mit) {
        ArrayList<String> params = new ArrayList<String>();
        Matcher matcher = PRINTF_PARAM_PATTERN.matcher(formatString);
        while (matcher.find()) {
            if (AbstractPrintfChecker.firstArgumentIsLT(params, matcher.group(2))) {
                this.reportMissingPrevious(mit);
                continue;
            }
            StringBuilder param = new StringBuilder();
            for (int groupIndex : new int[]{1, 2, 5, 6}) {
                if (matcher.group(groupIndex) == null) continue;
                param.append(matcher.group(groupIndex));
            }
            String specifier = param.toString();
            if ("%".equals(specifier)) continue;
            params.add(specifier);
        }
        return params;
    }

    protected void reportMissingPrevious(MethodInvocationTree mit) {
    }

    protected static Integer getIndex(String param) {
        return Integer.valueOf(param.substring(0, param.indexOf(36)));
    }

    protected static void cleanupLineSeparator(List<String> params) {
        Iterator<String> iter = params.iterator();
        while (iter.hasNext()) {
            String param = iter.next();
            if (!"n".equals(param)) continue;
            iter.remove();
        }
    }

    protected static Set<Integer> argIndexes(List<String> params) {
        int index = 0;
        HashSet<Integer> result = new HashSet<Integer>();
        for (String rawParam : params) {
            if (rawParam.contains("$")) {
                result.add(AbstractPrintfChecker.getIndex(rawParam));
                continue;
            }
            if (rawParam.charAt(0) == '<') continue;
            result.add(++index);
        }
        return result;
    }

    private static boolean firstArgumentIsLT(List<String> params, @Nullable String group) {
        return params.isEmpty() && group != null && group.length() > 0 && group.charAt(0) == '<';
    }

    @Nullable
    protected static List<ExpressionTree> transposeArgumentArrayAndRemoveThrowable(MethodInvocationTree mit, List<ExpressionTree> args) {
        ExpressionTree firstArg;
        ListTree transposedArgs = args;
        if (args.size() == 1 && (firstArg = args.get(0)).symbolType().isArray()) {
            if (AbstractPrintfChecker.isNewArrayWithInitializers(firstArg)) {
                transposedArgs = ((NewArrayTree)firstArg).initializers();
            } else {
                return null;
            }
        }
        if (AbstractPrintfChecker.lastArgumentShouldBeIgnored(mit, args, transposedArgs)) {
            transposedArgs = transposedArgs.subList(0, transposedArgs.size() - 1);
        }
        return transposedArgs;
    }

    private static boolean lastArgumentShouldBeIgnored(MethodInvocationTree mit, List<ExpressionTree> args, List<ExpressionTree> transposedArgs) {
        if (mit.symbol().owner().type().is(JAVA_UTIL_LOGGING_LOGGER)) {
            return args.size() == 1 && AbstractPrintfChecker.isLastArgumentThrowable(args);
        }
        return AbstractPrintfChecker.isLastArgumentThrowable(transposedArgs);
    }

    protected static boolean isLastArgumentThrowable(List<ExpressionTree> arguments) {
        if (!arguments.isEmpty()) {
            ExpressionTree lastArgument = arguments.get(arguments.size() - 1);
            return lastArgument.symbolType().isSubtypeOf(JAVA_LANG_THROWABLE);
        }
        return false;
    }

    protected static boolean isLoggingMethod(MethodInvocationTree mit) {
        String methodName = mit.symbol().name();
        return "log".equals(methodName) || LEVELS.contains(methodName);
    }
}

