/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S3398")
public class CallOuterPrivateMethodCheck
extends IssuableSubscriptionVisitor {
    private MethodInvocationVisitor methodInvocationVisitor;

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.INTERFACE);
    }

    public void setContext(JavaFileScannerContext context) {
        this.methodInvocationVisitor = new MethodInvocationVisitor();
        super.setContext(context);
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.methodInvocationVisitor.checkUsages();
        this.methodInvocationVisitor = null;
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        if (CallOuterPrivateMethodCheck.isInnerClass((Symbol)classSymbol)) {
            this.methodInvocationVisitor.setClassSymbol(classSymbol);
            classTree.accept((TreeVisitor)this.methodInvocationVisitor);
        }
    }

    private static boolean isInnerClass(Symbol symbol) {
        return symbol.owner().isTypeSymbol();
    }

    private class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private final Map<Symbol.TypeSymbol, Multiset<Symbol>> usagesByInnerClass = new HashMap<Symbol.TypeSymbol, Multiset<Symbol>>();
        private final Multimap<String, MethodInvocationTree> unknownInvocations = HashMultimap.create();
        private Symbol.TypeSymbol classSymbol;
        private Multiset<Symbol> usages;

        private MethodInvocationVisitor() {
        }

        public void setClassSymbol(Symbol.TypeSymbol classSymbol) {
            this.classSymbol = classSymbol;
            this.usages = HashMultiset.create();
            this.usagesByInnerClass.put(classSymbol, this.usages);
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Symbol symbol = tree.symbol();
            if (symbol.isUnknown()) {
                this.unknownInvocations.put((Object)ExpressionUtils.methodName((MethodInvocationTree)tree).name(), (Object)tree);
            } else if (this.isPrivateMethodOfOuterClass(symbol)) {
                if (JUtils.isParametrizedMethod((Symbol.MethodSymbol)((Symbol.MethodSymbol)symbol)) && symbol.declaration() != null) {
                    symbol = ((Symbol.MethodSymbol)symbol).declaration().symbol();
                }
                this.usages.add((Object)symbol);
            }
            super.visitMethodInvocation(tree);
        }

        private boolean isPrivateMethodOfOuterClass(Symbol symbol) {
            return symbol.isPrivate() && symbol.owner().equals(this.classSymbol.owner()) && !"<init>".equals(symbol.name());
        }

        void checkUsages() {
            for (Map.Entry<Symbol.TypeSymbol, Multiset<Symbol>> usageByInnerClassEntry : this.usagesByInnerClass.entrySet()) {
                Multiset<Symbol> innerClassUsages = usageByInnerClassEntry.getValue();
                for (Symbol methodUsed : innerClassUsages.elementSet()) {
                    boolean matchArity = this.unknownInvocations.get((Object)methodUsed.name()).stream().anyMatch(mit -> this.hasSameArity((Symbol.MethodSymbol)methodUsed, (MethodInvocationTree)mit));
                    if (matchArity || methodUsed.usages().size() != innerClassUsages.count((Object)methodUsed)) continue;
                    this.reportIssueOnMethod((MethodTree)methodUsed.declaration(), usageByInnerClassEntry.getKey());
                }
            }
        }

        private boolean hasSameArity(Symbol.MethodSymbol methodUsed, MethodInvocationTree mit) {
            int invokedArity;
            int formalArity = methodUsed.parameterTypes().size();
            return formalArity == (invokedArity = mit.arguments().size()) || JUtils.isVarArgsMethod((Symbol.MethodSymbol)methodUsed) && invokedArity >= formalArity - 1;
        }

        private void reportIssueOnMethod(@Nullable MethodTree declaration, Symbol.TypeSymbol classSymbol) {
            if (declaration != null) {
                String message = "Move this method into ";
                message = classSymbol.name().isEmpty() ? message + "the anonymous class declared at line " + ((JavaTree)classSymbol.declaration()).getLine() + "." : message + "\"" + classSymbol.name() + "\".";
                CallOuterPrivateMethodCheck.this.reportIssue((Tree)declaration.simpleName(), message);
            }
        }
    }
}

