/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3981")
public class CollectionSizeAndArrayLengthCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers COLLECTION_SIZE = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Collection"}).names(new String[]{"size"}).addWithoutParametersMatcher().build();
    private static final String COLLECTION_ISSUE_MSG = "The size of %s is always \">=0\", so update this test to use isEmpty().";
    private static final String ARRAY_ISSUE_MSG = "The length of %s is always \">=0\", so update this test to either \"==0\" or \">0\".";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO);
    }

    public void visitNode(Tree tree) {
        ExpressionTree testedValue;
        if (!this.hasSemantic()) {
            return;
        }
        BinaryExpressionTree bet = (BinaryExpressionTree)tree;
        ExpressionTree leftOperand = ExpressionUtils.skipParentheses((ExpressionTree)bet.leftOperand());
        ExpressionTree rightOperand = ExpressionUtils.skipParentheses((ExpressionTree)bet.rightOperand());
        boolean leftIsZero = LiteralUtils.isZero((ExpressionTree)leftOperand);
        boolean rightIsZero = LiteralUtils.isZero((ExpressionTree)rightOperand);
        if (!leftIsZero && !rightIsZero) {
            return;
        }
        ExpressionTree expressionTree = testedValue = leftIsZero ? rightOperand : leftOperand;
        if (testedValue.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            this.checkCollectionSize((MethodInvocationTree)testedValue, bet, leftIsZero);
        } else if (testedValue.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.checkArrayLength((MemberSelectExpressionTree)testedValue, bet, leftIsZero);
        }
    }

    private void checkCollectionSize(MethodInvocationTree testedValue, BinaryExpressionTree bet, boolean leftIsZero) {
        if (!COLLECTION_SIZE.matches(testedValue)) {
            return;
        }
        this.reportIssue(bet, leftIsZero, COLLECTION_ISSUE_MSG, CollectionSizeAndArrayLengthCheck.collectionName(testedValue.methodSelect()));
    }

    private static String collectionName(ExpressionTree sizeMethodSelect) {
        if (sizeMethodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree collectionAccess = ((MemberSelectExpressionTree)sizeMethodSelect).expression();
            if (collectionAccess.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return CollectionSizeAndArrayLengthCheck.escape(((IdentifierTree)collectionAccess).name());
            }
        }
        return "a collection";
    }

    private static String escape(String s) {
        return "\"" + s + "\"";
    }

    private void reportIssue(BinaryExpressionTree bet, boolean leftIsZero, String message, String itemName) {
        if (leftIsZero && bet.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO}) || !leftIsZero && bet.is(new Tree.Kind[]{Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO})) {
            this.reportIssue((Tree)bet, String.format(message, itemName));
        }
    }

    private void checkArrayLength(MemberSelectExpressionTree testedValue, BinaryExpressionTree bet, boolean leftIsZero) {
        if (!"length".equals(testedValue.identifier().name())) {
            return;
        }
        ExpressionTree expression = testedValue.expression();
        if (!expression.symbolType().isArray()) {
            return;
        }
        this.reportIssue(bet, leftIsZero, ARRAY_ISSUE_MSG, CollectionSizeAndArrayLengthCheck.arrayName(expression));
    }

    private static String arrayName(ExpressionTree expr) {
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return CollectionSizeAndArrayLengthCheck.escape(((IdentifierTree)expr).name());
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return CollectionSizeAndArrayLengthCheck.escape(((MemberSelectExpressionTree)expr).identifier().name());
        }
        return "an array";
    }
}

