/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5361")
public class StringReplaceCheck
extends AbstractMethodDetection {
    private static final String LANG_STRING = "java.lang.String";
    private static final char[] REGEX_META = ".$|([{^?*+\\".toCharArray();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{LANG_STRING}).names(new String[]{"replaceAll"}).addParametersMatcher(new String[]{LANG_STRING, LANG_STRING}).build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree regexArg = (ExpressionTree)mit.arguments().get(0);
        regexArg.asConstant(String.class).filter(r -> !StringReplaceCheck.isRegex(r)).ifPresent(r -> this.reportIssue((Tree)((MemberSelectExpressionTree)mit.methodSelect()).identifier(), "Replace this call to \"replaceAll()\" by a call to the \"replace()\" method."));
    }

    private static boolean isRegex(String s) {
        for (char c : s.toCharArray()) {
            for (char meta : REGEX_META) {
                if (c != meta) continue;
                return true;
            }
        }
        return false;
    }
}

