/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;

@Rule(key="S4970")
public class UnreachableCatchCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TRY_STATEMENT);
    }

    public void visitNode(Tree tree) {
        TryStatementTree tryStatementTree = (TryStatementTree)tree;
        if (!tryStatementTree.resourceList().isEmpty()) {
            return;
        }
        HashMap<Type, Tree> typeToTypeTree = new HashMap<Type, Tree>();
        Multimap<Type, Type> baseToSubtype = UnreachableCatchCheck.getBaseTypeCaughtAfterSubtype(tryStatementTree.catches(), typeToTypeTree);
        if (baseToSubtype.isEmpty()) {
            return;
        }
        ThrownExceptionCollector collector = new ThrownExceptionCollector();
        tryStatementTree.block().accept((TreeVisitor)collector);
        if (collector.unknownVisited || collector.thrownTypes.isEmpty()) {
            return;
        }
        List<Type> thrownTypes = collector.thrownTypes;
        baseToSubtype.asMap().forEach((baseType, subtypes) -> {
            List subtypesHiding = subtypes.stream().filter(subtype -> UnreachableCatchCheck.isHiding(subtype, thrownTypes)).collect(Collectors.toList());
            if (!subtypesHiding.isEmpty()) {
                this.reportIssue((Tree)typeToTypeTree.get(baseType), "Remove this type because it is unreachable as hidden by previous catch blocks.", subtypesHiding.stream().map(type -> new JavaFileScannerContext.Location("Already catch the exception", (Tree)typeToTypeTree.get(type))).collect(Collectors.toList()), null);
            }
        });
    }

    private static Multimap<Type, Type> getBaseTypeCaughtAfterSubtype(List<CatchTree> catches, Map<Type, Tree> typeToTypeTree) {
        HashMultimap baseAfterSubtype = HashMultimap.create();
        List catchTypes = catches.stream().flatMap(c -> {
            ArrayList<Type> types = new ArrayList<Type>();
            UnreachableCatchCheck.collectTypesFromTypeTree(c.parameter().type(), types, typeToTypeTree);
            return types.stream();
        }).filter(UnreachableCatchCheck::isChecked).collect(Collectors.toList());
        for (int i = 0; i < catchTypes.size() - 1; ++i) {
            Type topType = (Type)catchTypes.get(i);
            for (int j = i + 1; j < catchTypes.size(); ++j) {
                Type bottomType = (Type)catchTypes.get(j);
                if (!topType.isSubtypeOf(bottomType)) continue;
                baseAfterSubtype.put((Object)bottomType, (Object)topType);
            }
        }
        return baseAfterSubtype;
    }

    private static void collectTypesFromTypeTree(TypeTree typeTree, List<Type> types, Map<Type, Tree> typeToTypeTree) {
        if (typeTree.is(new Tree.Kind[]{Tree.Kind.UNION_TYPE})) {
            ((UnionTypeTree)typeTree).typeAlternatives().forEach(t -> UnreachableCatchCheck.collectTypesFromTypeTree(t, types, typeToTypeTree));
        } else {
            Type type = typeTree.symbolType();
            typeToTypeTree.put(type, (Tree)typeTree);
            types.add(type);
        }
    }

    private static boolean isChecked(Type type) {
        return !type.isUnknown() && !type.isSubtypeOf("java.lang.RuntimeException") && !type.isSubtypeOf("java.lang.Error") && !type.is("java.lang.Exception") && !type.is("java.lang.Throwable");
    }

    private static boolean isHiding(Type subtype, List<Type> thrownTypes) {
        return thrownTypes.stream().allMatch(thrownType -> thrownType.isSubtypeOf(subtype));
    }

    private static class ThrownExceptionCollector
    extends BaseTreeVisitor {
        List<Type> thrownTypes = new ArrayList<Type>();
        boolean unknownVisited = false;

        private ThrownExceptionCollector() {
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            this.addAllThrownTypes(mit.symbol());
            super.visitMethodInvocation(mit);
        }

        public void visitNewClass(NewClassTree tree) {
            this.addAllThrownTypes(tree.constructorSymbol());
            super.visitNewClass(tree);
        }

        public void visitThrowStatement(ThrowStatementTree tree) {
            this.thrownTypes.add(tree.expression().symbolType());
            super.visitThrowStatement(tree);
        }

        private void addAllThrownTypes(Symbol symbol) {
            if (symbol.isMethodSymbol()) {
                this.thrownTypes.addAll(((Symbol.MethodSymbol)symbol).thrownTypes());
            } else if (symbol.isUnknown()) {
                this.unknownVisited = true;
            }
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }
    }
}

