/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.io.File;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;

@Rule(key="S4032")
public class UselessPackageInfoCheck
implements JavaFileScanner {
    public void scanFile(JavaFileScannerContext context) {
        File file = context.getInputFile().file();
        if ("package-info.java".equals(file.getName()) && UselessPackageInfoCheck.isOnlyFileFromPackage(file)) {
            context.addIssueOnFile((JavaCheck)this, "Remove this package.");
        }
    }

    private static boolean isOnlyFileFromPackage(File file) {
        return file.getParentFile().listFiles(f -> !f.equals(file)).length == 0;
    }
}

