/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S4499")
public class SMTPSSLServerIdentityCheck
extends AbstractMethodDetection {
    private static final String APACHE_EMAIL = "org.apache.commons.mail.Email";
    private static final String BOOLEAN = "boolean";
    private static final String HASHTABLE = "java.util.Hashtable";
    private static final Set<String> ENABLING_SSL_METHOD_NAMES = new HashSet<String>(Arrays.asList("setSSL", "setSSLOnConnect", "setTLS", "setStartTLSEnabled", "setStartTLSRequired"));
    private static final MethodMatchers ENABLING_SSL_METHODS = MethodMatchers.create().ofSubTypes(new String[]{"org.apache.commons.mail.Email"}).name(ENABLING_SSL_METHOD_NAMES::contains).addParametersMatcher(new String[]{"boolean"}).build();
    private static final MethodMatchers HASHTABLE_PUT = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Hashtable"}).names(new String[]{"put"}).withAnyParameters().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{ENABLING_SSL_METHODS, HASHTABLE_PUT});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        MethodTree method = ExpressionUtils.getEnclosingMethod((ExpressionTree)mit);
        if (method != null) {
            Arguments args = mit.arguments();
            if (ENABLING_SSL_METHODS.matches(mit) && LiteralUtils.isTrue((Tree)((Tree)args.get(0)))) {
                MethodBodyApacheVisitor apacheVisitor = new MethodBodyApacheVisitor();
                method.accept((TreeVisitor)apacheVisitor);
                if (!apacheVisitor.isSecured) {
                    this.reportIssue((Tree)mit, "Enable server identity validation on this SMTP SSL connection.");
                }
            } else if (HASHTABLE_PUT.matches(mit) && "mail.smtp.socketFactory.class".equals(ExpressionsHelper.getConstantValueAsString((ExpressionTree)args.get(0)).value()) && "javax.net.ssl.SSLSocketFactory".equals(ExpressionsHelper.getConstantValueAsString((ExpressionTree)args.get(1)).value())) {
                MethodBodyHashtableVisitor hashVisitor = new MethodBodyHashtableVisitor();
                method.accept((TreeVisitor)hashVisitor);
                if (!hashVisitor.isSecured) {
                    this.reportIssue((Tree)mit, "Enable server identity validation, set \"mail.smtp.ssl.checkserveridentity\" to true");
                }
            }
        }
        super.onMethodInvocationFound(mit);
    }

    private static boolean isNotFalse(ExpressionTree expression) {
        return !LiteralUtils.isFalse((Tree)expression);
    }

    private static class MethodBodyApacheVisitor
    extends BaseTreeVisitor {
        private boolean isSecured = false;
        private static final MethodMatchers SET_SSL_CHECK_SERVER_ID = MethodMatchers.create().ofSubTypes(new String[]{"org.apache.commons.mail.Email"}).names(new String[]{"setSSLCheckServerIdentity"}).addParametersMatcher(new String[]{"boolean"}).build();

        private MethodBodyApacheVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (SET_SSL_CHECK_SERVER_ID.matches(mit) && SMTPSSLServerIdentityCheck.isNotFalse((ExpressionTree)mit.arguments().get(0))) {
                this.isSecured = true;
            }
            super.visitMethodInvocation(mit);
        }
    }

    private static class MethodBodyHashtableVisitor
    extends BaseTreeVisitor {
        private boolean isSecured = false;

        private MethodBodyHashtableVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            Arguments args = mit.arguments();
            if (HASHTABLE_PUT.matches(mit) && "mail.smtp.ssl.checkserveridentity".equals(ExpressionsHelper.getConstantValueAsString((ExpressionTree)args.get(0)).value()) && SMTPSSLServerIdentityCheck.isNotFalse((ExpressionTree)args.get(1))) {
                this.isSecured = true;
            }
            super.visitMethodInvocation(mit);
        }
    }
}

