/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.checks.tests.AssertJChainSimplificationCheck;
import org.sonar.java.checks.tests.AssertJChainSimplificationHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

public class AssertJChainSimplificationIndex {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_UTIL_MAP = "java.util.Map";
    private static final String JAVA_UTIL_COLLECTION = "java.util.Collection";
    private static final String JAVA_IO_FILE = "java.io.File";
    private static final String JAVA_NIO_FILE_PATH = "java.nio.file.Path";
    private static final String JAVA_UTIL_OPTIONAL = "java.util.Optional";
    private static final String CONTAINS = "contains";
    private static final String DOES_NOT_CONTAIN = "doesNotContain";
    private static final String DOES_NOT_START_WITH = "doesNotStartWith";
    private static final String HAS_SIZE = "hasSize";
    private static final String IS_EMPTY = "isEmpty";
    private static final String IS_EQUAL_TO = "isEqualTo";
    private static final String IS_EQUAL_TO_IGNORING_CASE = "isEqualToIgnoringCase";
    private static final String IS_FALSE = "isFalse";
    private static final String IS_GREATER_THAN = "isGreaterThan";
    private static final String IS_GREATER_THAN_OR_EQUAL_TO = "isGreaterThanOrEqualTo";
    private static final String IS_LESS_THAN = "isLessThan";
    private static final String IS_LESS_THAN_OR_EQUAL_TO = "isLessThanOrEqualTo";
    private static final String IS_NEGATIVE = "isNegative";
    private static final String IS_NOT_BLANK = "isNotBlank";
    private static final String IS_NOT_EMPTY = "isNotEmpty";
    private static final String IS_NOT_EQUAL_TO = "isNotEqualTo";
    private static final String IS_NOT_EQUAL_TO_IGNORING_CASE = "isNotEqualToIgnoringCase";
    private static final String IS_NOT_NEGATIVE = "isNotNegative";
    private static final String IS_NOT_NULL = "isNotNull";
    private static final String IS_NOT_POSITIVE = "isNotPositive";
    private static final String IS_NOT_PRESENT = "isNotPresent";
    private static final String IS_NOT_ZERO = "isNotZero";
    private static final String IS_POSITIVE = "isPositive";
    private static final String IS_PRESENT = "isPresent";
    private static final String IS_SAME_AS = "isSameAs";
    private static final String IS_TRUE = "isTrue";
    private static final String IS_ZERO = "isZero";
    private static final String IS_NULL = "isNull";
    private static final String STARTS_WITH = "startsWith";
    private static final String ENDS_WITH = "endsWith";
    private static final String HAS_SAME_SIZE_AS = "hasSameSizeAs";
    private static final String LENGTH = "length";
    private static final String OPTIONAL_PRESENT_REPLACEMENT = AssertJChainSimplificationHelper.msgWithActual("isPresent");
    private static final String OPTIONAL_EMPTY_REPLACEMENT = String.format("%s or %s", AssertJChainSimplificationHelper.msgWithActual("isNotPresent"), AssertJChainSimplificationHelper.msgWithActual("isEmpty"));
    static final Map<String, List<AssertJChainSimplificationCheck.SimplifierWithoutContext>> CONTEXT_FREE_SIMPLIFIERS = ImmutableMap.builder().put((Object)"hasSize", Collections.singletonList(PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isZero, "isEmpty()"))).put((Object)"isEqualTo", (Object)ImmutableList.of((Object)PredicateSimplifierWithoutContext.withSingleArg(ExpressionUtils::isNullLiteral, "isNull()"), (Object)PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isTrue, "isTrue()"), (Object)PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isFalse, "isFalse()"), (Object)PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isEmptyString, "isEmpty()"), (Object)PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isZero, "isZero()"))).put((Object)"isGreaterThan", (Object)ImmutableList.of((Object)PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isNegOne, "isNotNegative()"), (Object)PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isZero, "isPositive()"))).put((Object)"isGreaterThanOrEqualTo", (Object)ImmutableList.of((Object)PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isZero, "isNotNegative()"), (Object)PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isOne, "isPositive()"))).put((Object)"isLessThan", (Object)ImmutableList.of((Object)PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isZero, "isNegative()"), (Object)PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isOne, "isNotPositive()"))).put((Object)"isLessThanOrEqualTo", (Object)ImmutableList.of((Object)PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isNegOne, "isNegative()"), (Object)PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isZero, "isNotPositive()"))).put((Object)"isNotEqualTo", (Object)ImmutableList.of((Object)PredicateSimplifierWithoutContext.withSingleArg(subject -> ExpressionUtils.isNullLiteral((ExpressionTree)subject) && !UnitTestUtils.isInUnitTestRelatedToObjectMethods(subject), "isNotNull()"), (Object)PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isZero, "isNotZero()"))).build();
    static final Map<String, List<AssertJChainSimplificationCheck.SimplifierWithContext>> SIMPLIFIERS_WITH_CONTEXT = ImmutableMap.builder().put((Object)"isEqualTo", (Object)ImmutableList.of((Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.TO_STRING, AssertJChainSimplificationHelper.msgWithActualCustom("hasToString", "expectedString")), (Object)PredicateSimplifierWithContext.methodCallInSubject(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.HASH_CODE), Matchers.HASH_CODE, AssertJChainSimplificationHelper.msgWithActualExpected("hasSameHashCodeAs")), (Object)AssertJChainSimplificationIndex.compareToSimplifier(LiteralUtils::isZero, AssertJChainSimplificationHelper.msgWithActualExpected("isEqualByComparingTo")), (Object)PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isZero, Matchers.COMPARE_TO_IGNORE_CASE, AssertJChainSimplificationHelper.msgWithActualExpected("isEqualToIgnoringCase")), (Object)AssertJChainSimplificationIndex.indexOfSimplifier(LiteralUtils::isZero, "startsWith"), (Object)AssertJChainSimplificationIndex.indexOfSimplifier(LiteralUtils::isNegOne, "doesNotContain"), (Object)PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isZero, Matchers.STRING_LENGTH, AssertJChainSimplificationHelper.msgWithActual("isEmpty")), (Object)PredicateSimplifierWithContext.methodCallInSubject(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.STRING_LENGTH), Matchers.STRING_LENGTH, AssertJChainSimplificationHelper.msgWithActualExpected("hasSameSizeAs")), (Object)PredicateSimplifierWithContext.methodCallInSubject(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.COLLECTION_SIZE), Matchers.COLLECTION_SIZE, AssertJChainSimplificationHelper.msgWithActualExpected("hasSameSizeAs")), (Object)PredicateSimplifierWithContext.withSubjectArgumentCondition(AssertJChainSimplificationIndex::isArrayLength, AssertJChainSimplificationIndex::isArrayLength, AssertJChainSimplificationHelper.msgWithActualExpected("hasSameSizeAs")), (Object)AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("hasSize")), (Object)PredicateSimplifierWithContext.methodCallInSubject(MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{Matchers.STRING_LENGTH, Matchers.COLLECTION_SIZE}), AssertJChainSimplificationHelper.msgWithActualExpected("hasSize")), (Object[])new AssertJChainSimplificationCheck.SimplifierWithContext[]{PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LENGTH, AssertJChainSimplificationHelper.msgWithActualExpected("hasSize")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_GET_NAME, AssertJChainSimplificationHelper.msgWithActualExpected("hasName")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_GET_PARENT_AND_PARENT_FILE, AssertJChainSimplificationHelper.msgWithActualExpected("hasParent")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_GET_PARENT_AND_PARENT_FILE, AssertJChainSimplificationHelper.msgWithActualExpected("hasParentRaw")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_GET, AssertJChainSimplificationHelper.msgWithActualCustom("containsEntry", "key, value")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_GET_PARENT_AND_PARENT_FILE, AssertJChainSimplificationHelper.msgWithActualExpected("hasParentRaw")), PredicateSimplifierWithContext.withSubjectArgumentCondition(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.EMPTY), subjectArg -> subjectArg.symbolType().is(JAVA_UTIL_OPTIONAL), OPTIONAL_EMPTY_REPLACEMENT), PredicateSimplifierWithContext.methodCallInSubject(Matchers.GET, AssertJChainSimplificationHelper.msgWithActualExpected("contains"))})).put((Object)"isFalse", (Object)ImmutableList.of((Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.EQUALS_METHOD, AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualTo")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.CONTENT_EQUALS, AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualTo")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.EQUALS_IGNORE_CASE, AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualToIgnoringCase")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.CONTAINS, AssertJChainSimplificationHelper.msgWithActualExpected("doesNotContain")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.STARTS_WITH, AssertJChainSimplificationHelper.msgWithActualExpected("doesNotStartWith")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.ENDS_WITH, AssertJChainSimplificationHelper.msgWithActualExpected("doesNotEndWith")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.MATCHES, AssertJChainSimplificationHelper.msgWithActualExpected("doesNotMatch")), (Object)PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.ArgumentHelper.equalsTo(arg, ExpressionUtils::isNullLiteral), AssertJChainSimplificationHelper.msgWithActual("isNotNull")), (Object)PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.ArgumentHelper.notEqualsTo(arg, ExpressionUtils::isNullLiteral), AssertJChainSimplificationHelper.msgWithActual("isNull")), (Object)PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}), AssertJChainSimplificationHelper.msgWithActualExpected("isNotSameAs")), (Object)PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}), AssertJChainSimplificationHelper.msgWithActualExpected("isSameAs")), (Object)PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.INSTANCE_OF}), AssertJChainSimplificationHelper.msgWithActualCustom("isNotInstanceOf", "ExpectedClass.class")), (Object[])new AssertJChainSimplificationCheck.SimplifierWithContext[]{PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_GENERIC, AssertJChainSimplificationHelper.msgWithActual("isNotEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_EXISTS, AssertJChainSimplificationHelper.msgWithActual("doesNotExist")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_AND_PATH_IS_ABSOLUTE, AssertJChainSimplificationHelper.msgWithActual("isRelative")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_PRESENT, OPTIONAL_EMPTY_REPLACEMENT), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_OPTIONAL, OPTIONAL_PRESENT_REPLACEMENT)})).put((Object)"isNegative", (Object)ImmutableList.of((Object)AssertJChainSimplificationIndex.compareToSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("isLessThan")), (Object)AssertJChainSimplificationIndex.indexOfSimplifier("doesNotContain"))).put((Object)"isEmpty", Collections.singletonList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LIST_AND_LIST_FILE, AssertJChainSimplificationHelper.msgWithActual("isEmptyDirectory")))).put((Object)"isNotEmpty", (Object)ImmutableList.of((Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.TRIM, AssertJChainSimplificationHelper.msgWithActual("isNotBlank")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LIST_AND_LIST_FILE, AssertJChainSimplificationHelper.msgWithActual("isNotEmptyDirectory")))).put((Object)"isNotEqualTo", (Object)ImmutableList.of((Object)AssertJChainSimplificationIndex.compareToSimplifier(LiteralUtils::isZero, AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualByComparingTo")), (Object)PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isZero, Matchers.COMPARE_TO_IGNORE_CASE, AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualToIgnoringCase")), (Object)AssertJChainSimplificationIndex.indexOfSimplifier(LiteralUtils::isZero, "doesNotStartWith"), (Object)PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isEmptyString, Matchers.TRIM, AssertJChainSimplificationHelper.msgWithActual("isNotBlank")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_GET, AssertJChainSimplificationHelper.msgWithActualCustom("doesNotContainEntry", "key, value")), (Object)PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isEmptyString, Matchers.TRIM, AssertJChainSimplificationHelper.msgWithActual("isNotBlank")), (Object)PredicateSimplifierWithContext.withSubjectArgumentCondition(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.EMPTY), subjectArg -> subjectArg.symbolType().is(JAVA_UTIL_OPTIONAL), OPTIONAL_PRESENT_REPLACEMENT))).put((Object)"isNotNegative", (Object)ImmutableList.of((Object)AssertJChainSimplificationIndex.compareToSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("isGreaterThanOrEqualTo")), (Object)AssertJChainSimplificationIndex.indexOfSimplifier("contains"))).put((Object)"isNotNull", Collections.singletonList(PredicateSimplifierWithContext.withSubjectArgumentCondition(subjectArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(subjectArg, Matchers.OR_ELSE) && ExpressionUtils.isNullLiteral((ExpressionTree)((ExpressionTree)((MethodInvocationTree)subjectArg).arguments().get(0))), OPTIONAL_PRESENT_REPLACEMENT))).put((Object)"isNotPositive", (Object)ImmutableList.of((Object)AssertJChainSimplificationIndex.compareToSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("isLessThanOrEqualTo")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.STRING_LENGTH, AssertJChainSimplificationHelper.msgWithActual("isEmpty")))).put((Object)"isNotZero", (Object)ImmutableList.of((Object)AssertJChainSimplificationIndex.compareToSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualByComparingTo")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.COMPARE_TO_IGNORE_CASE, AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualToIgnoringCase")), (Object)AssertJChainSimplificationIndex.indexOfSimplifier("doesNotStartWith"), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.STRING_LENGTH, AssertJChainSimplificationHelper.msgWithActual("isNotEmpty")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LENGTH, AssertJChainSimplificationHelper.msgWithActual("isNotEmpty")), (Object)AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActual("isNotEmpty")))).put((Object)"isPositive", (Object)ImmutableList.of((Object)AssertJChainSimplificationIndex.compareToSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("isGreaterThan")), (Object)AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActual("isNotEmpty")))).put((Object)"isSameAs", Collections.singletonList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.GET, AssertJChainSimplificationHelper.msgWithActualExpected("containsSame")))).put((Object)"isTrue", (Object)ImmutableList.of((Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.EQUALS_METHOD, AssertJChainSimplificationHelper.msgWithActualExpected("isEqualTo")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.CONTENT_EQUALS, AssertJChainSimplificationHelper.msgWithActualExpected("isEqualTo")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.EQUALS_IGNORE_CASE, AssertJChainSimplificationHelper.msgWithActualExpected("isEqualToIgnoringCase")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.CONTAINS, AssertJChainSimplificationHelper.msgWithActualExpected("contains")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_CONTAINS_ALL, AssertJChainSimplificationHelper.msgWithActualExpected("containsAll")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.STARTS_WITH, AssertJChainSimplificationHelper.msgWithActualExpected("startsWith")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.ENDS_WITH, AssertJChainSimplificationHelper.msgWithActualExpected("endsWith")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.MATCHES, AssertJChainSimplificationHelper.msgWithActualExpected("matches")), (Object)PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.ArgumentHelper.equalsTo(arg, ExpressionUtils::isNullLiteral), AssertJChainSimplificationHelper.msgWithActual("isNull")), (Object)PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.ArgumentHelper.notEqualsTo(arg, ExpressionUtils::isNullLiteral), AssertJChainSimplificationHelper.msgWithActual("isNotNull")), (Object)PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}), AssertJChainSimplificationHelper.msgWithActualExpected("isSameAs")), (Object)PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}), AssertJChainSimplificationHelper.msgWithActualExpected("isNotSameAs")), (Object[])new AssertJChainSimplificationCheck.SimplifierWithContext[]{PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.INSTANCE_OF}), AssertJChainSimplificationHelper.msgWithActualCustom("isInstanceOf", "ExpectedClass.class")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_GENERIC, AssertJChainSimplificationHelper.msgWithActual("isEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_CAN_READ, AssertJChainSimplificationHelper.msgWithActual("canRead")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_CAN_WRITE, AssertJChainSimplificationHelper.msgWithActual("canWrite")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_EXISTS, AssertJChainSimplificationHelper.msgWithActual("exists")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_AND_PATH_IS_ABSOLUTE, AssertJChainSimplificationHelper.msgWithActual("isAbsolute")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_IS_DIRECTORY, AssertJChainSimplificationHelper.msgWithActual("isDirectory")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_IS_FILE, AssertJChainSimplificationHelper.msgWithActual("isFile")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_STARTS_WITH, AssertJChainSimplificationHelper.msgWithActualExpected("startsWithRaw")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_ENDS_WITH, AssertJChainSimplificationHelper.msgWithActualExpected("endsWithRaw")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_GENERIC, AssertJChainSimplificationHelper.msgWithActual("isEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_CONTAINS_KEY, AssertJChainSimplificationHelper.msgWithActualExpected("containsKey")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_CONTAINS_VALUE, AssertJChainSimplificationHelper.msgWithActualExpected("containsValue")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_PRESENT, OPTIONAL_PRESENT_REPLACEMENT), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_OPTIONAL, OPTIONAL_EMPTY_REPLACEMENT)})).put((Object)"isZero", (Object)ImmutableList.of((Object)AssertJChainSimplificationIndex.compareToSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("isEqualByComparingTo")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.COMPARE_TO_IGNORE_CASE, AssertJChainSimplificationHelper.msgWithActualExpected("isEqualToIgnoringCase")), (Object)AssertJChainSimplificationIndex.indexOfSimplifier("startsWith"), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.STRING_LENGTH, AssertJChainSimplificationHelper.msgWithActual("isEmpty")), (Object)PredicateSimplifierWithContext.methodCallInSubject(MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{Matchers.STRING_LENGTH, Matchers.COLLECTION_SIZE}), AssertJChainSimplificationHelper.msgWithActual("isEmpty")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LENGTH, AssertJChainSimplificationHelper.msgWithActual("isEmpty")), (Object)AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActual("isEmpty")))).put((Object)"isNull", (Object)ImmutableList.of((Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_GET_PARENT_AND_PARENT_FILE, AssertJChainSimplificationHelper.msgWithActual("hasNoParent")), (Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_GET_PARENT_AND_PARENT_FILE, AssertJChainSimplificationHelper.msgWithActual("hasNoParentRaw")), (Object)PredicateSimplifierWithContext.withSubjectArgumentCondition(subjectArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(subjectArg, Matchers.OR_ELSE) && ExpressionUtils.isNullLiteral((ExpressionTree)((ExpressionTree)((MethodInvocationTree)subjectArg).arguments().get(0))), OPTIONAL_EMPTY_REPLACEMENT))).put((Object)"isLessThanOrEqualTo", (Object)ImmutableList.of((Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_SIZE, AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeLessThanOrEqualTo")), (Object)AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeLessThanOrEqualTo")))).put((Object)"isLessThan", (Object)ImmutableList.of((Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_SIZE, AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeLessThan")), (Object)AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeLessThan")))).put((Object)"isGreaterThanOrEqualTo", (Object)ImmutableList.of((Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_SIZE, AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeGreaterThanOrEqualTo")), (Object)AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeGreaterThanOrEqualTo")))).put((Object)"isGreaterThan", (Object)ImmutableList.of((Object)PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_SIZE, AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeGreaterThan")), (Object)AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeGreaterThan")))).build();

    private AssertJChainSimplificationIndex() {
    }

    private static PredicateSimplifierWithContext compareToSimplifier(Predicate<ExpressionTree> predicateArgCondition, String simplification) {
        return PredicateSimplifierWithContext.methodCallInSubject(predicateArgCondition, Matchers.COMPARE_TO, simplification);
    }

    private static PredicateSimplifierWithContext compareToSimplifier(String simplification) {
        return PredicateSimplifierWithContext.methodCallInSubject(Matchers.COMPARE_TO, simplification);
    }

    private static PredicateSimplifierWithContext indexOfSimplifier(Predicate<ExpressionTree> predicateArgCondition, String simplification) {
        return PredicateSimplifierWithContext.methodCallInSubject(predicateArgCondition, Matchers.INDEX_OF_STRING, AssertJChainSimplificationHelper.msgWithActualExpected(simplification));
    }

    private static PredicateSimplifierWithContext indexOfSimplifier(String simplification) {
        return PredicateSimplifierWithContext.methodCallInSubject(Matchers.INDEX_OF_STRING, AssertJChainSimplificationHelper.msgWithActualExpected(simplification));
    }

    private static PredicateSimplifierWithContext arrayLengthSimplifier(String simplification) {
        return PredicateSimplifierWithContext.withSubjectArgumentCondition(AssertJChainSimplificationIndex::isArrayLength, simplification);
    }

    private static boolean isArrayLength(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)expression;
            return memberSelectExpressionTree.expression().symbolType().isArray() && LENGTH.equals(memberSelectExpressionTree.identifier().name());
        }
        return false;
    }

    static class PredicateSimplifierWithContext
    implements AssertJChainSimplificationCheck.SimplifierWithContext {
        private final Predicate<MethodInvocationTree> predicateCondition;
        private final Predicate<MethodInvocationTree> subjectCondition;
        private final String simplification;

        public PredicateSimplifierWithContext(Predicate<MethodInvocationTree> predicateCondition, Predicate<MethodInvocationTree> subjectCondition, String simplification) {
            this.predicateCondition = predicateCondition;
            this.subjectCondition = subjectCondition;
            this.simplification = simplification;
        }

        public static PredicateSimplifierWithContext withSubjectArgumentCondition(Predicate<ExpressionTree> predicateArgumentCondition, Predicate<ExpressionTree> subjectArgumentCondition, String simplification) {
            return new PredicateSimplifierWithContext(predicateMit -> predicateMit.arguments().size() == 1 && predicateArgumentCondition.test(ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)predicateMit.arguments().get(0)))), subjectMit -> subjectMit.arguments().size() == 1 && subjectArgumentCondition.test(ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)subjectMit.arguments().get(0)))), simplification);
        }

        public static PredicateSimplifierWithContext withSubjectArgumentCondition(Predicate<ExpressionTree> subjectArgumentCondition, String simplification) {
            return new PredicateSimplifierWithContext(x -> true, subjectMit -> subjectMit.arguments().size() == 1 && subjectArgumentCondition.test(ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)subjectMit.arguments().get(0)))), simplification);
        }

        public static PredicateSimplifierWithContext methodCallInSubject(MethodMatchers methodCallMatcher, String simplification) {
            return PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(arg, methodCallMatcher), simplification);
        }

        public static PredicateSimplifierWithContext methodCallInSubject(Predicate<ExpressionTree> predicateArgumentCondition, MethodMatchers methodCallMatcher, String simplification) {
            return PredicateSimplifierWithContext.withSubjectArgumentCondition(predicateArgumentCondition, arg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(arg, methodCallMatcher), simplification);
        }

        @Override
        public Optional<String> simplify(MethodInvocationTree subject, MethodInvocationTree predicate) {
            if (this.predicateCondition.test(predicate) && this.subjectCondition.test(subject)) {
                return Optional.of(this.simplification);
            }
            return Optional.empty();
        }
    }

    private static class PredicateSimplifierWithoutContext
    implements AssertJChainSimplificationCheck.SimplifierWithoutContext {
        private final Predicate<MethodInvocationTree> mitPredicate;
        private final String simplification;

        public PredicateSimplifierWithoutContext(Predicate<MethodInvocationTree> mitPredicate, String simplification) {
            this.mitPredicate = mitPredicate;
            this.simplification = simplification;
        }

        public static PredicateSimplifierWithoutContext withSingleArg(Predicate<ExpressionTree> argumentPredicate, String simplified) {
            return new PredicateSimplifierWithoutContext(mit -> {
                Arguments arguments = mit.arguments();
                return arguments.size() == 1 && argumentPredicate.test((ExpressionTree)arguments.get(0));
            }, simplified);
        }

        @Override
        public Optional<String> simplify(MethodInvocationTree predicate) {
            if (this.mitPredicate.test(predicate)) {
                return Optional.of(this.simplification);
            }
            return Optional.empty();
        }
    }

    private static class Matchers {
        public static final MethodMatchers COMPARE_TO = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Comparable"}).names(new String[]{"compareTo"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers COMPARE_TO_IGNORE_CASE = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.String"}).names(new String[]{"compareToIgnoreCase"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers CONTAINS = MethodMatchers.create().ofTypes(new String[]{"java.lang.String", "java.util.Collection"}).names(new String[]{"contains"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers CONTENT_EQUALS = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"contentEquals"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers EMPTY = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"}).names(new String[]{"empty"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers ENDS_WITH = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"endsWith"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers EQUALS_IGNORE_CASE = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"equalsIgnoreCase"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers EQUALS_METHOD = MethodMatchers.create().ofAnyType().names(new String[]{"equals"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers HASH_CODE = MethodMatchers.create().ofAnyType().names(new String[]{"hashCode"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers INDEX_OF_STRING = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"indexOf"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
        public static final MethodMatchers IS_EMPTY_GENERIC = MethodMatchers.create().ofTypes(new String[]{"java.lang.String", "java.util.Collection", "java.util.Map"}).names(new String[]{"isEmpty"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers IS_EMPTY_OPTIONAL = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"}).names(new String[]{"isEmpty"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers IS_PRESENT = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"}).names(new String[]{"isPresent"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers STRING_LENGTH = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"length"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_LENGTH = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"length"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers MATCHES = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"matches"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers STARTS_WITH = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"startsWith"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers TO_STRING = MethodMatchers.create().ofAnyType().names(new String[]{"toString"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers TRIM = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"trim"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_CAN_READ = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"canRead"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_CAN_WRITE = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"canWrite"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_EXISTS = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"exists"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_GET_NAME = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"getName"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_GET_PARENT_AND_PARENT_FILE = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"getParent", "getParentFile"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_AND_PATH_IS_ABSOLUTE = MethodMatchers.create().ofTypes(new String[]{"java.io.File", "java.nio.file.Path"}).names(new String[]{"isAbsolute"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_IS_DIRECTORY = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"isDirectory"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_IS_FILE = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"isFile"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_LIST_AND_LIST_FILE = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"list", "listFiles"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers GET = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"}).names(new String[]{"get"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers OR_ELSE = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"}).names(new String[]{"orElse"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers PATH_GET_PARENT_AND_PARENT_FILE = MethodMatchers.create().ofTypes(new String[]{"java.nio.file.Path"}).names(new String[]{"getParent"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers PATH_STARTS_WITH = MethodMatchers.create().ofTypes(new String[]{"java.nio.file.Path"}).names(new String[]{"startsWith"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
        public static final MethodMatchers PATH_ENDS_WITH = MethodMatchers.create().ofTypes(new String[]{"java.nio.file.Path"}).names(new String[]{"endsWith"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
        public static final MethodMatchers COLLECTION_SIZE = MethodMatchers.create().ofTypes(new String[]{"java.util.Collection", "java.util.Map"}).names(new String[]{"size"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers COLLECTION_CONTAINS_ALL = MethodMatchers.create().ofTypes(new String[]{"java.util.Collection"}).names(new String[]{"containsAll"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers MAP_CONTAINS_KEY = MethodMatchers.create().ofTypes(new String[]{"java.util.Map"}).names(new String[]{"containsKey"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers MAP_CONTAINS_VALUE = MethodMatchers.create().ofTypes(new String[]{"java.util.Map"}).names(new String[]{"containsValue"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers MAP_GET = MethodMatchers.create().ofTypes(new String[]{"java.util.Map"}).names(new String[]{"get"}).addParametersMatcher(new String[]{"*"}).build();

        private Matchers() {
        }
    }
}

