/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.api.rule.RuleKey;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.filters.JavaIssueFilter;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AnyRuleIssueFilter
extends BaseTreeVisitor
implements JavaIssueFilter {
    private String componentKey;
    private final Set<Integer> excludedLines = new HashSet<Integer>();

    public void scanFile(JavaFileScannerContext context) {
        this.componentKey = context.getInputFile().key();
        this.excludedLines.clear();
        this.scan((Tree)context.getTree());
    }

    @Override
    public boolean accept(RuleKey ruleKey, AnalyzerMessage analyzerMessage) {
        return !analyzerMessage.getInputComponent().key().equals(this.componentKey) || !this.excludedLines.contains(analyzerMessage.getLine());
    }

    @Override
    public final Set<Class<? extends JavaCheck>> filteredRules() {
        return Collections.emptySet();
    }

    public void excludeLines(Tree tree) {
        this.excludedLines.addAll(AnyRuleIssueFilter.filteredLines(tree));
    }

    private static Set<Integer> filteredLines(Tree tree) {
        SyntaxToken firstSyntaxToken = tree.firstToken();
        SyntaxToken lastSyntaxToken = tree.lastToken();
        if (firstSyntaxToken != null && lastSyntaxToken != null) {
            int startLine = firstSyntaxToken.line();
            int endLine = lastSyntaxToken.line();
            List trivias = firstSyntaxToken.trivias();
            if (!trivias.isEmpty()) {
                startLine = ((SyntaxTrivia)trivias.get(0)).startLine();
            }
            return ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(startLine), (Comparable)Integer.valueOf(endLine)), (DiscreteDomain)DiscreteDomain.integers());
        }
        return new HashSet<Integer>();
    }
}

