/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.resolve.Symbols;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2175")
public class CollectionInappropriateCallsCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_UTIL_COLLECTION = "java.util.Collection";
    private static final List<TypeChecker> TYPE_CHECKERS = TypeCheckerListBuilder.access$800(TypeCheckerListBuilder.access$600(TypeCheckerListBuilder.access$500(TypeCheckerListBuilder.access$400(TypeCheckerListBuilder.access$300(TypeCheckerListBuilder.access$600(TypeCheckerListBuilder.access$500(TypeCheckerListBuilder.access$400(TypeCheckerListBuilder.access$300(TypeCheckerListBuilder.access$600(TypeCheckerListBuilder.access$500(TypeCheckerListBuilder.access$400(TypeCheckerListBuilder.access$300(TypeCheckerListBuilder.access$200(TypeCheckerListBuilder.access$600(TypeCheckerListBuilder.access$500(TypeCheckerListBuilder.access$400(TypeCheckerListBuilder.access$300(TypeCheckerListBuilder.access$200(TypeCheckerListBuilder.access$600(TypeCheckerListBuilder.access$500(TypeCheckerListBuilder.access$400(TypeCheckerListBuilder.access$300(TypeCheckerListBuilder.access$200(TypeCheckerListBuilder.access$600(TypeCheckerListBuilder.access$500(TypeCheckerListBuilder.access$400(TypeCheckerListBuilder.access$300(TypeCheckerListBuilder.access$200(TypeCheckerListBuilder.access$600(TypeCheckerListBuilder.access$500(TypeCheckerListBuilder.access$400(TypeCheckerListBuilder.access$300(TypeCheckerListBuilder.access$200(TypeCheckerListBuilder.access$100(TypeCheckerListBuilder.access$600(TypeCheckerListBuilder.access$500(TypeCheckerListBuilder.access$400(TypeCheckerListBuilder.access$300(TypeCheckerListBuilder.access$200(TypeCheckerListBuilder.access$600(TypeCheckerListBuilder.access$500(TypeCheckerListBuilder.access$400(TypeCheckerListBuilder.access$300(TypeCheckerListBuilder.access$200(TypeCheckerListBuilder.access$100(TypeCheckerListBuilder.access$600(TypeCheckerListBuilder.access$500(TypeCheckerListBuilder.access$400(TypeCheckerListBuilder.access$300(TypeCheckerListBuilder.access$200(TypeCheckerListBuilder.access$600(TypeCheckerListBuilder.access$700(TypeCheckerListBuilder.access$400(TypeCheckerListBuilder.access$300(TypeCheckerListBuilder.access$200(TypeCheckerListBuilder.access$600(TypeCheckerListBuilder.access$500(TypeCheckerListBuilder.access$400(TypeCheckerListBuilder.access$300(TypeCheckerListBuilder.access$200(TypeCheckerListBuilder.access$100(new TypeCheckerListBuilder(), "java.util.Collection"), "remove"), 1), 1), 1)), "removeAll"), 1), 1), 1)), "contains"), 1), 1), 1)), "java.util.List"), "indexOf"), 1), 1), 1)), "lastIndexOf"), 1), 1), 1)), "java.util.Map"), "containsKey"), 1), 1), 1)), "containsValue"), 1), 1), 2)), "get"), 1), 1), 1)), "getOrDefault"), 1), 2), 1)), "remove"), 1), 1), 1)), 1), 2), 1)), 2), 2), 2)));

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            TYPE_CHECKERS.stream().filter(typeChecker -> ((TypeChecker)typeChecker).methodMatcher.matches(mit)).forEach(typeChecker -> this.checkMethodInvocation(mit, (TypeChecker)typeChecker));
        }
    }

    private void checkMethodInvocation(MethodInvocationTree tree, TypeChecker typeChecker) {
        ExpressionTree argument = (ExpressionTree)tree.arguments().get(typeChecker.argumentIndex);
        Type argumentTypeToCheck = argument.symbolType();
        if (typeChecker.argumentIsACollection) {
            argumentTypeToCheck = CollectionInappropriateCallsCheck.getTypeArgumentAt(CollectionInappropriateCallsCheck.findSuperTypeMatching(argumentTypeToCheck, JAVA_UTIL_COLLECTION), 0);
        }
        if (argumentTypeToCheck.isUnknown()) {
            return;
        }
        Type actualMethodType = CollectionInappropriateCallsCheck.getMethodOwnerType(tree);
        Type checkedMethodType = CollectionInappropriateCallsCheck.findSuperTypeMatching(actualMethodType, typeChecker.methodOwnerType);
        Type parameterType = CollectionInappropriateCallsCheck.getTypeArgumentAt(checkedMethodType, typeChecker.parametrizedTypeIndex);
        boolean isCallToParametrizedOrUnknownMethod = CollectionInappropriateCallsCheck.isCallToParametrizedOrUnknownMethod(argument);
        if (!isCallToParametrizedOrUnknownMethod && tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            isCallToParametrizedOrUnknownMethod = CollectionInappropriateCallsCheck.isCallToParametrizedOrUnknownMethod(((MemberSelectExpressionTree)tree.methodSelect()).expression());
        }
        if (!(checkedMethodType.isUnknown() || parameterType.isUnknown() || isCallToParametrizedOrUnknownMethod || CollectionInappropriateCallsCheck.isArgumentCompatible(argumentTypeToCheck, parameterType))) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)tree), CollectionInappropriateCallsCheck.message(actualMethodType, checkedMethodType, parameterType, argumentTypeToCheck));
        }
    }

    private static String message(Type actualMethodType, Type checkedMethodType, Type parameterType, Type argumentType) {
        String typeDescription;
        String actualType = CollectionInappropriateCallsCheck.typeNameWithParameters(actualMethodType);
        boolean actualTypeHasTheParameterType = actualMethodType.typeArguments().stream().anyMatch(typeArg -> typeArg.equals(parameterType));
        boolean checkedTypeHasSeveralParameters = checkedMethodType.typeArguments().size() > 1;
        String string = typeDescription = checkedTypeHasSeveralParameters ? " in a \"" + parameterType + "\" type" : "";
        if (actualTypeHasTheParameterType) {
            return MessageFormat.format("A \"{0}\" cannot contain a \"{1}\"{2}.", actualType, argumentType.name(), typeDescription);
        }
        String checkedType = CollectionInappropriateCallsCheck.typeNameWithParameters(checkedMethodType);
        return MessageFormat.format("\"{0}\" is a \"{1}\" which cannot contain a \"{2}\"{3}.", actualType, checkedType, argumentType.name(), typeDescription);
    }

    private static String typeNameWithParameters(Type type) {
        if (type.isParameterized()) {
            return type.name() + type.typeArguments().stream().map(Type::name).collect(Collectors.joining(", ", "<", ">"));
        }
        return type.name();
    }

    private static boolean isCallToParametrizedOrUnknownMethod(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            Symbol.MethodSymbol symbol = (Symbol.MethodSymbol)((MethodInvocationTree)expressionTree).symbol();
            return symbol.isUnknown() || JUtils.isParametrizedMethod((Symbol.MethodSymbol)symbol);
        }
        return false;
    }

    private static Type getMethodOwnerType(MethodInvocationTree mit) {
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)mit.methodSelect()).expression().symbolType();
        }
        return mit.symbol().owner().type();
    }

    private static Type getTypeArgumentAt(Type type, int index) {
        List parameters;
        if (type.isParameterized() && index < (parameters = type.typeArguments()).size()) {
            return (Type)parameters.get(index);
        }
        return Symbols.unknownType;
    }

    private static Type findSuperTypeMatching(Type type, String genericTypeName) {
        if (type.is(genericTypeName)) {
            return type;
        }
        return JUtils.superTypes((Symbol.TypeSymbol)type.symbol()).stream().filter(superType -> superType.is(genericTypeName)).findFirst().orElse(Symbols.unknownType);
    }

    private static boolean isArgumentCompatible(Type argumentType, Type collectionParameterType) {
        return CollectionInappropriateCallsCheck.isSubtypeOf(argumentType, collectionParameterType) || CollectionInappropriateCallsCheck.isSubtypeOf(collectionParameterType, argumentType) || CollectionInappropriateCallsCheck.autoboxing(argumentType, collectionParameterType);
    }

    private static boolean isSubtypeOf(Type type, Type superType) {
        return type.isSubtypeOf(superType.erasure());
    }

    private static boolean autoboxing(Type argumentType, Type collectionParameterType) {
        return argumentType.isPrimitive() && JUtils.isPrimitiveWrapper((Type)collectionParameterType) && CollectionInappropriateCallsCheck.isSubtypeOf(JUtils.primitiveWrapperType((Type)argumentType), collectionParameterType);
    }

    private static class TypeCheckerListBuilder {
        private final List<TypeChecker> typeCheckers = new ArrayList<TypeChecker>();
        private String methodOwnerType;
        private String methodName;
        private int argumentPosition;
        private boolean argumentIsACollection;
        private int argumentCount;
        private int parametrizedTypePosition;

        private TypeCheckerListBuilder() {
        }

        private TypeCheckerListBuilder on(String methodOwnerType) {
            this.methodOwnerType = methodOwnerType;
            return this;
        }

        private TypeCheckerListBuilder method(String methodName) {
            this.methodName = methodName;
            return this;
        }

        private TypeCheckerListBuilder argument(int argumentPosition) {
            this.argumentPosition = argumentPosition;
            return this;
        }

        private TypeCheckerListBuilder outOf(int argumentCount) {
            this.argumentCount = argumentCount;
            return this;
        }

        private TypeCheckerListBuilder shouldMatchParametrizedType(int parametrizedTypePosition) {
            this.parametrizedTypePosition = parametrizedTypePosition;
            this.argumentIsACollection = false;
            return this;
        }

        private TypeCheckerListBuilder shouldMatchCollectionOfParametrizedType(int parametrizedTypePosition) {
            this.parametrizedTypePosition = parametrizedTypePosition;
            this.argumentIsACollection = true;
            return this;
        }

        private TypeCheckerListBuilder add() {
            int argumentIndex = this.argumentPosition - 1;
            int parametrizedTypeIndex = this.parametrizedTypePosition - 1;
            ArrayList<String> methodMatcherParameters = new ArrayList<String>();
            for (int i = 0; i < this.argumentCount; ++i) {
                String parameterType = "*";
                if (i == argumentIndex) {
                    parameterType = this.argumentIsACollection ? CollectionInappropriateCallsCheck.JAVA_UTIL_COLLECTION : "java.lang.Object";
                }
                methodMatcherParameters.add(parameterType);
            }
            MethodMatchers methodMatcher = MethodMatchers.create().ofSubTypes(new String[]{this.methodOwnerType}).names(new String[]{this.methodName}).addParametersMatcher(methodMatcherParameters.toArray(new String[0])).build();
            this.typeCheckers.add(new TypeChecker(this.methodOwnerType, methodMatcher, argumentIndex, this.argumentIsACollection, parametrizedTypeIndex));
            return this;
        }

        private List<TypeChecker> build() {
            return this.typeCheckers;
        }

        static /* synthetic */ TypeCheckerListBuilder access$100(TypeCheckerListBuilder x0, String x1) {
            return x0.on(x1);
        }

        static /* synthetic */ TypeCheckerListBuilder access$200(TypeCheckerListBuilder x0, String x1) {
            return x0.method(x1);
        }

        static /* synthetic */ TypeCheckerListBuilder access$300(TypeCheckerListBuilder x0, int x1) {
            return x0.argument(x1);
        }

        static /* synthetic */ TypeCheckerListBuilder access$400(TypeCheckerListBuilder x0, int x1) {
            return x0.outOf(x1);
        }

        static /* synthetic */ TypeCheckerListBuilder access$500(TypeCheckerListBuilder x0, int x1) {
            return x0.shouldMatchParametrizedType(x1);
        }

        static /* synthetic */ TypeCheckerListBuilder access$600(TypeCheckerListBuilder x0) {
            return x0.add();
        }

        static /* synthetic */ TypeCheckerListBuilder access$700(TypeCheckerListBuilder x0, int x1) {
            return x0.shouldMatchCollectionOfParametrizedType(x1);
        }

        static /* synthetic */ List access$800(TypeCheckerListBuilder x0) {
            return x0.build();
        }
    }

    private static class TypeChecker {
        private final String methodOwnerType;
        private final MethodMatchers methodMatcher;
        private final int argumentIndex;
        private boolean argumentIsACollection;
        private final int parametrizedTypeIndex;

        private TypeChecker(String methodOwnerType, MethodMatchers methodMatcher, int argumentIndex, boolean argumentIsACollection, int parametrizedTypeIndex) {
            this.methodOwnerType = methodOwnerType;
            this.methodMatcher = methodMatcher;
            this.argumentIndex = argumentIndex;
            this.argumentIsACollection = argumentIsACollection;
            this.parametrizedTypeIndex = parametrizedTypeIndex;
        }
    }
}

