/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S1194")
public class ErrorClassExtendedCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        TypeTree superClass = ((ClassTree)tree).superClass();
        if (superClass != null && superClass.symbolType().isSubtypeOf("java.lang.Error")) {
            this.reportIssue((Tree)superClass, "Extend \"java.lang.Exception\" or one of its subclasses.");
        }
    }
}

