/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2386")
public class PublicStaticMutableMembersCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> ALWAYS_MUTABLE_TYPES = ImmutableSet.of((Object)"java.awt.Point", (Object)"java.util.Date");
    private static final Set<String> MUTABLE_TYPES = ImmutableSet.builder().addAll(ALWAYS_MUTABLE_TYPES).add((Object)"java.util.Collection").add((Object)"java.util.Map").build();
    private static final String DECORATE = "decorate";
    private static final MethodMatchers UNMODIFIABLE_METHOD_CALLS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.util.Collections"}).name(name -> name.startsWith("singleton") || name.startsWith("empty")).withAnyParameters().build(), MethodMatchers.create().ofAnyType().name(name -> name.startsWith("unmodifiable")).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.Set", "java.util.List", "java.util.Map"}).names(new String[]{"of", "ofEntries", "copyOf"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"org.apache.commons.collections.map.UnmodifiableMap", "org.apache.commons.collections.list.UnmodifiableList", "org.apache.commons.collections.set.UnmodifiableSet", "org.apache.commons.collections4.map.UnmodifiableMap", "org.apache.commons.collections4.set.UnmodifiableSet", "org.apache.commons.collections4.list.UnmodifiableList"}).names(new String[]{"decorate"}).withAnyParameters().build()});
    private static final MethodMatchers ARRAYS_AS_LIST = MethodMatchers.create().ofTypes(new String[]{"java.util.Arrays"}).names(new String[]{"asList"}).withAnyParameters().build();
    private static final Set<String> ACCEPTED_TYPES = ImmutableSet.of((Object)"com.google.common.collect.ImmutableMap", (Object)"com.google.common.collect.ImmutableCollection");
    private static final Set<String> ACCEPTED_NEW_TYPES = Collections.singleton("org.apache.commons.collections4.list.UnmodifiableList");
    private static final Set<Symbol> IMMUTABLE_CANDIDATES = new HashSet<Symbol>();
    private static final Multimap<Tree, Symbol> CLASS_IMMUTABLE_CANDIDATES = ArrayListMultimap.create();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.INTERFACE, Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.ASSIGNMENT);
    }

    public void leaveFile(JavaFileScannerContext context) {
        CLASS_IMMUTABLE_CANDIDATES.clear();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            this.checkAssignment((AssignmentExpressionTree)tree);
        } else {
            List members = ((ClassTree)tree).members();
            for (Tree member : members) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
                this.preCheckVariable(tree, (VariableTree)member);
            }
        }
    }

    private void preCheckVariable(Tree owner, VariableTree variableTree) {
        Symbol symbol = variableTree.symbol();
        if (symbol != null && PublicStaticMutableMembersCheck.isPublicStatic(symbol) && PublicStaticMutableMembersCheck.isForbiddenType(symbol.type())) {
            if (PublicStaticMutableMembersCheck.isMutable(variableTree.initializer(), symbol)) {
                String message = "Make this member \"protected\".";
                if (owner.is(new Tree.Kind[]{Tree.Kind.INTERFACE})) {
                    message = MessageFormat.format("Move \"{0}\" to a class and lower its visibility", variableTree.simpleName().name());
                }
                this.reportIssue((Tree)variableTree.simpleName(), message);
            } else {
                IMMUTABLE_CANDIDATES.add(symbol);
                CLASS_IMMUTABLE_CANDIDATES.put((Object)owner, (Object)symbol);
            }
        }
    }

    private void checkAssignment(AssignmentExpressionTree node) {
        IdentifierTree identifierTree;
        Symbol symbol;
        ExpressionTree variable = ExpressionUtils.skipParentheses((ExpressionTree)node.variable());
        if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            variable = ((MemberSelectExpressionTree)variable).identifier();
        }
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && IMMUTABLE_CANDIDATES.contains(symbol = (identifierTree = (IdentifierTree)variable).symbol()) && PublicStaticMutableMembersCheck.isMutable(node.expression(), symbol)) {
            this.reportIssue((Tree)identifierTree, "Make member \"" + symbol.name() + "\" \"protected\".");
            IMMUTABLE_CANDIDATES.remove(symbol);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM})) {
            IMMUTABLE_CANDIDATES.removeAll(CLASS_IMMUTABLE_CANDIDATES.get((Object)tree));
        }
    }

    static boolean isMutable(@Nullable ExpressionTree initializer, Symbol symbol) {
        Type type = symbol.type();
        if (initializer == null) {
            return ALWAYS_MUTABLE_TYPES.stream().anyMatch(arg_0 -> ((Type)type).isSubtypeOf(arg_0));
        }
        if (symbol.isFinal() && PublicStaticMutableMembersCheck.isEmptyArray(initializer)) {
            return false;
        }
        ExpressionTree expression = ExpressionUtils.skipParentheses((ExpressionTree)initializer);
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return PublicStaticMutableMembersCheck.returnValueIsMutable((MethodInvocationTree)expression);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            return !PublicStaticMutableMembersCheck.isAcceptedType(expression.symbolType(), ACCEPTED_NEW_TYPES);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol assigned = ((IdentifierTree)expression).symbol();
            return !IMMUTABLE_CANDIDATES.contains(assigned);
        }
        return true;
    }

    private static boolean isEmptyArray(ExpressionTree expression) {
        if (!expression.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            return false;
        }
        NewArrayTree nat = (NewArrayTree)expression;
        return PublicStaticMutableMembersCheck.hasEmptyInitializer(nat) || PublicStaticMutableMembersCheck.hasOnlyZeroDimensions(nat.dimensions());
    }

    private static boolean hasEmptyInitializer(NewArrayTree newArrayTree) {
        return newArrayTree.openBraceToken() != null && newArrayTree.initializers().isEmpty();
    }

    private static boolean hasOnlyZeroDimensions(List<ArrayDimensionTree> dimensions) {
        return !dimensions.isEmpty() && dimensions.stream().allMatch(PublicStaticMutableMembersCheck::isZeroDimension);
    }

    private static boolean isZeroDimension(ArrayDimensionTree dim) {
        ExpressionTree expression = dim.expression();
        return expression != null && LiteralUtils.isZero((ExpressionTree)expression);
    }

    private static boolean returnValueIsMutable(MethodInvocationTree mit) {
        if (PublicStaticMutableMembersCheck.isAcceptedTypeOrUnmodifiableMethodCall(mit)) {
            return false;
        }
        if (ARRAYS_AS_LIST.matches(mit)) {
            return !mit.arguments().isEmpty();
        }
        return true;
    }

    private static boolean isAcceptedTypeOrUnmodifiableMethodCall(MethodInvocationTree mit) {
        Type type = mit.symbolType();
        return type.isUnknown() || PublicStaticMutableMembersCheck.isAcceptedType(type, ACCEPTED_TYPES) || UNMODIFIABLE_METHOD_CALLS.matches(mit);
    }

    private static boolean isAcceptedType(Type type, Set<String> accepted) {
        for (String acceptedType : accepted) {
            if (!type.isSubtypeOf(acceptedType)) continue;
            return true;
        }
        return false;
    }

    static boolean isPublicStatic(Symbol symbol) {
        return symbol.isStatic() && symbol.isPublic();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isForbiddenType(Type type) {
        if (type.isArray()) return true;
        if (!MUTABLE_TYPES.stream().anyMatch(arg_0 -> ((Type)type).isSubtypeOf(arg_0))) return false;
        return true;
    }
}

