/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4266")
public class RedundantStreamCollectCheck
extends AbstractMethodDetection {
    private static final String[] STREAM_TYPES = new String[]{"java.util.stream.Stream", "java.util.stream.IntStream", "java.util.stream.LongStream", "java.util.stream.DoubleStream"};
    private static final MethodMatchers COUNTING = RedundantStreamCollectCheck.streamCollectorsMatcher().names(new String[]{"counting"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers MAX_BY = RedundantStreamCollectCheck.streamCollectorsMatcher().names(new String[]{"maxBy"}).withAnyParameters().build();
    private static final MethodMatchers MIN_BY = RedundantStreamCollectCheck.streamCollectorsMatcher().names(new String[]{"minBy"}).withAnyParameters().build();
    private static final MethodMatchers MAPPING = RedundantStreamCollectCheck.streamCollectorsMatcher().names(new String[]{"mapping"}).withAnyParameters().build();
    private static final MethodMatchers REDUCING = RedundantStreamCollectCheck.streamCollectorsMatcher().names(new String[]{"reducing"}).withAnyParameters().build();
    private static final MethodMatchers SUMMING_INT = RedundantStreamCollectCheck.streamCollectorsMatcher().names(new String[]{"summingInt"}).withAnyParameters().build();
    private static final MethodMatchers SUMMING_LONG = RedundantStreamCollectCheck.streamCollectorsMatcher().names(new String[]{"summingLong"}).withAnyParameters().build();
    private static final MethodMatchers SUMMING_DOUBLE = RedundantStreamCollectCheck.streamCollectorsMatcher().names(new String[]{"summingDouble"}).withAnyParameters().build();
    private static final Map<MethodMatchers, String> REPLACEMENTS = ImmutableMap.builder().put((Object)COUNTING, (Object)"count()").put((Object)MAX_BY, (Object)"max()").put((Object)MIN_BY, (Object)"min()").put((Object)MAPPING, (Object)"map(...).collect()").put((Object)REDUCING, (Object)"reduce(...).collect()").put((Object)SUMMING_INT, (Object)"mapToInt(...).sum()").put((Object)SUMMING_LONG, (Object)"mapToLong(...).sum()").put((Object)SUMMING_DOUBLE, (Object)"mapToDouble(...).sum()").build();

    private static MethodMatchers.NameBuilder streamCollectorsMatcher() {
        return MethodMatchers.create().ofTypes(new String[]{"java.util.stream.Collectors"});
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(STREAM_TYPES).names(new String[]{"collect"}).addParametersMatcher(new String[]{"java.util.stream.Collector"}).build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree collectMIT) {
        ExpressionTree argument = (ExpressionTree)collectMIT.arguments().get(0);
        if (argument.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)argument;
            REPLACEMENTS.entrySet().stream().filter(e -> ((MethodMatchers)e.getKey()).matches(methodInvocation)).findFirst().ifPresent(e -> this.context.reportIssue((JavaCheck)this, (Tree)ExpressionUtils.methodName((MethodInvocationTree)methodInvocation), "Use \"" + (String)e.getValue() + "\" instead."));
        }
    }
}

