/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2109")
public class ReflectionOnNonRuntimeAnnotationCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofSubTypes(new String[]{"java.lang.reflect.AnnotatedElement"}).names(new String[]{"isAnnotationPresent"}).withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree expressionTree = (ExpressionTree)mit.arguments().get(0);
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)expressionTree;
            boolean isClassIdentifier = memberSelect.identifier().name().equals("class");
            Type symbolType = memberSelect.expression().symbolType();
            if (isClassIdentifier && !symbolType.isUnknown() && ReflectionOnNonRuntimeAnnotationCheck.isNotRuntimeAnnotation(symbolType)) {
                this.reportIssue((Tree)expressionTree, "\"@" + symbolType.name() + "\" is not available at runtime and cannot be seen with reflection.");
            }
        }
    }

    private static boolean isNotRuntimeAnnotation(Type symbolType) {
        List valuesFor = symbolType.symbol().metadata().valuesForAnnotation("java.lang.annotation.Retention");
        if (valuesFor == null) {
            return true;
        }
        String retentionValue = ReflectionOnNonRuntimeAnnotationCheck.getRetentionValue(((SymbolMetadata.AnnotationValue)valuesFor.get(0)).value());
        return !"RUNTIME".equals(retentionValue);
    }

    @Nullable
    private static String getRetentionValue(Object value) {
        if (value instanceof Symbol.VariableSymbol) {
            return ((Symbol.VariableSymbol)value).name();
        }
        return null;
    }
}

