/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;

public final class UnitTestUtils {
    public static final MethodMatchers FAIL_METHOD_MATCHER = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.junit.jupiter.api.Assertions", "org.junit.Assert", "junit.framework.Assert", "org.fest.assertions.Fail", "org.assertj.core.api.Fail", "org.assertj.core.api.Assertions"}).names(new String[]{"fail"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.api.Assertions"}).names(new String[]{"failBecauseExceptionWasNotThrown"}).withAnyParameters().build()});
    public static final MethodMatchers ASSERTIONS_METHOD_MATCHER = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert", "org.junit.jupiter.api.Assertions", "junit.framework.Assert", "junit.framework.TestCase"}).name(name -> name.startsWith("assert")).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.api.Assertions", "org.fest.assertions.Assertions"}).names(new String[]{"assertThat"}).withAnyParameters().build()});
    public static final MethodMatchers COMMON_ASSERTION_MATCHER = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{FAIL_METHOD_MATCHER, ASSERTIONS_METHOD_MATCHER});
    private static final Set<String> TEST_ANNOTATIONS = new HashSet<String>(Arrays.asList("org.junit.Test", "org.testng.annotations.Test"));
    private static final Set<String> JUNIT5_TEST_ANNOTATIONS = new HashSet<String>(Arrays.asList("org.junit.jupiter.api.Test", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.api.TestFactory", "org.junit.jupiter.api.TestTemplate", "org.junit.jupiter.params.ParameterizedTest"));
    private static final String NESTED_ANNOTATION = "org.junit.jupiter.api.Nested";
    private static final Pattern UNIT_TEST_NAME_RELATED_TO_OBJECT_METHODS_REGEX = Pattern.compile("equal|hash_?code|object_?method|to_?string", 2);

    private UnitTestUtils() {
    }

    public static boolean hasNestedAnnotation(ClassTree tree) {
        SymbolMetadata metadata = tree.symbol().metadata();
        return metadata.isAnnotatedWith(NESTED_ANNOTATION);
    }

    public static boolean hasTestAnnotation(MethodTree tree) {
        SymbolMetadata symbolMetadata = tree.symbol().metadata();
        return TEST_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)symbolMetadata).isAnnotatedWith(arg_0)) || UnitTestUtils.hasJUnit5TestAnnotation(symbolMetadata);
    }

    public static boolean hasJUnit5TestAnnotation(MethodTree tree) {
        return UnitTestUtils.hasJUnit5TestAnnotation(tree.symbol().metadata());
    }

    private static boolean hasJUnit5TestAnnotation(SymbolMetadata symbolMetadata) {
        return JUNIT5_TEST_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)symbolMetadata).isAnnotatedWith(arg_0));
    }

    public static boolean isInUnitTestRelatedToObjectMethods(ExpressionTree expr) {
        return UnitTestUtils.isUnitTestRelatedToObjectMethods(ExpressionUtils.getEnclosingMethod((ExpressionTree)expr));
    }

    public static boolean isUnitTestRelatedToObjectMethods(@Nullable MethodTree method) {
        return method != null && UNIT_TEST_NAME_RELATED_TO_OBJECT_METHODS_REGEX.matcher(method.simpleName().name()).find();
    }
}

