/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.BackReferenceTree;
import org.sonar.java.regex.ast.CharacterClassIntersectionTree;
import org.sonar.java.regex.ast.CharacterClassTree;
import org.sonar.java.regex.ast.DisjunctionTree;
import org.sonar.java.regex.ast.FlagSet;
import org.sonar.java.regex.ast.JavaCharacter;
import org.sonar.java.regex.ast.LookAroundTree;
import org.sonar.java.regex.ast.NonCapturingGroupTree;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RegexToken;
import org.sonar.java.regex.ast.RepetitionTree;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5843")
public class RegexComplexityCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Simplify this regular expression to reduce its complexity from %d to the %d allowed.";
    private static final int DEFAULT_MAX = 20;
    @RuleProperty(key="maxComplexity", description="The maximum authorized complexity.", defaultValue="20")
    private int max = 20;
    private final List<RegexConstructionInfo> regexConstructions = new ArrayList<RegexConstructionInfo>();
    private final Set<Integer> commentedLines = new HashSet<Integer>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> nodes = new ArrayList<Tree.Kind>(super.nodesToVisit());
        nodes.add(Tree.Kind.TRIVIA);
        return nodes;
    }

    @Override
    public void checkRegex(RegexParseResult parseResult, MethodInvocationTree mit) {
        ExpressionTree regexArgument = (ExpressionTree)mit.arguments().get(0);
        this.regexConstructions.add(new RegexConstructionInfo(regexArgument, parseResult.getInitialFlags(), parseResult.containsComments()));
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        this.commentedLines.add(syntaxTrivia.startLine());
        int numLines = StringUtils.countMatches((String)syntaxTrivia.comment(), (String)"\n");
        if (numLines > 0) {
            this.commentedLines.add(syntaxTrivia.startLine() + numLines);
        }
    }

    public void leaveFile(JavaFileScannerContext context) {
        for (RegexConstructionInfo regexInfo : this.regexConstructions) {
            FlagSet flags = regexInfo.initialFlags;
            for (LiteralTree[] regexPart : this.findRegexParts(regexInfo)) {
                new ComplexityCalculator().visit(this.regexForLiterals(flags, regexPart));
            }
        }
        this.regexConstructions.clear();
        this.commentedLines.clear();
    }

    List<LiteralTree[]> findRegexParts(RegexConstructionInfo regexInfo) {
        RegexPartFinder finder = new RegexPartFinder(regexInfo.initialFlags, regexInfo.containsComments);
        finder.find(regexInfo.regexArgument);
        return finder.parts;
    }

    public void setMax(int max) {
        this.max = max;
    }

    private static class RegexConstructionInfo {
        final ExpressionTree regexArgument;
        final FlagSet initialFlags;
        final boolean containsComments;

        RegexConstructionInfo(ExpressionTree regexArgument, FlagSet initialFlags, boolean containsComments) {
            this.regexArgument = regexArgument;
            this.initialFlags = initialFlags;
            this.containsComments = containsComments;
        }
    }

    private class ComplexityCalculator
    extends RegexBaseVisitor {
        int complexity = 0;
        int nesting = 1;
        List<RegexCheck.RegexIssueLocation> components = new ArrayList<RegexCheck.RegexIssueLocation>();
        private RegexSyntaxElement firstComponent = null;

        private ComplexityCalculator() {
        }

        private void increaseComplexity(RegexSyntaxElement syntaxElement, int increment) {
            this.complexity += increment;
            if (this.firstComponent == null) {
                this.firstComponent = syntaxElement;
            }
            String message = "+" + increment;
            if (increment > 1) {
                message = message + " (incl " + (increment - 1) + " for nesting)";
            }
            this.components.add(new RegexCheck.RegexIssueLocation(syntaxElement, message));
        }

        public void visitDisjunction(DisjunctionTree tree) {
            this.increaseComplexity((RegexSyntaxElement)tree.getOrOperators().get(0), this.nesting);
            for (JavaCharacter orOperator : tree.getOrOperators().subList(1, tree.getOrOperators().size())) {
                this.increaseComplexity((RegexSyntaxElement)orOperator, 1);
            }
            ++this.nesting;
            super.visitDisjunction(tree);
            --this.nesting;
        }

        public void visitRepetition(RepetitionTree tree) {
            this.increaseComplexity((RegexSyntaxElement)tree.getQuantifier(), this.nesting);
            ++this.nesting;
            super.visitRepetition(tree);
            --this.nesting;
        }

        public void visitCharacterClass(CharacterClassTree tree) {
            this.increaseComplexity((RegexSyntaxElement)tree.getOpeningBracket(), 1);
            ++this.nesting;
            super.visitCharacterClass(tree);
            --this.nesting;
        }

        public void visitCharacterClassIntersection(CharacterClassIntersectionTree tree) {
            this.increaseComplexity((RegexSyntaxElement)tree.getAndOperators().get(0), this.nesting - 1);
            for (RegexToken andOperator : tree.getAndOperators().subList(1, tree.getAndOperators().size())) {
                this.increaseComplexity((RegexSyntaxElement)andOperator, 1);
            }
            ++this.nesting;
            super.visitCharacterClassIntersection(tree);
            --this.nesting;
        }

        protected void doVisitNonCapturingGroup(NonCapturingGroupTree tree) {
            if (tree.getEnabledFlags().isEmpty() && tree.getDisabledFlags().isEmpty()) {
                super.doVisitNonCapturingGroup(tree);
            } else {
                if (tree.getGroupHeader() == null) {
                    this.increaseComplexity((RegexSyntaxElement)tree, this.nesting);
                } else {
                    this.increaseComplexity((RegexSyntaxElement)tree.getGroupHeader(), this.nesting);
                }
                ++this.nesting;
                super.doVisitNonCapturingGroup(tree);
                --this.nesting;
            }
        }

        public void visitLookAround(LookAroundTree tree) {
            this.increaseComplexity((RegexSyntaxElement)tree.getGroupHeader(), this.nesting);
            ++this.nesting;
            super.visitLookAround(tree);
            --this.nesting;
        }

        public void visitBackReference(BackReferenceTree tree) {
            this.increaseComplexity((RegexSyntaxElement)tree, 1);
        }

        protected void after(RegexParseResult regexParseResult) {
            if (this.complexity > RegexComplexityCheck.this.max) {
                RegexComplexityCheck.this.reportIssue(this.firstComponent, String.format(RegexComplexityCheck.MESSAGE, this.complexity, RegexComplexityCheck.this.max), (Integer)(this.complexity - RegexComplexityCheck.this.max), this.components);
            }
        }
    }

    private class RegexPartFinder {
        final FlagSet initialFlags;
        final boolean regexContainsComments;
        List<LiteralTree[]> parts = new ArrayList<LiteralTree[]>();

        RegexPartFinder(FlagSet initialFlags, boolean regexContainsComments) {
            this.initialFlags = initialFlags;
            this.regexContainsComments = regexContainsComments;
        }

        void find(ExpressionTree expr) {
            switch (expr.kind()) {
                case PLUS: {
                    ArrayList<LiteralTree> literals = new ArrayList<LiteralTree>();
                    this.findInStringConcatenation(expr, literals);
                    if (literals.isEmpty()) break;
                    this.parts.add(literals.toArray(new LiteralTree[0]));
                    break;
                }
                case IDENTIFIER: {
                    AbstractRegexCheck.getFinalVariableInitializer((IdentifierTree)expr).ifPresent(this::find);
                    break;
                }
                case PARENTHESIZED_EXPRESSION: {
                    this.find(ExpressionUtils.skipParentheses((ExpressionTree)expr));
                    break;
                }
                case STRING_LITERAL: {
                    this.parts.add(new LiteralTree[]{(LiteralTree)expr});
                    break;
                }
            }
        }

        void findInStringConcatenation(ExpressionTree expr, List<LiteralTree> literals) {
            if (expr.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
                LiteralTree literal = (LiteralTree)expr;
                if (this.isCommented(literal)) {
                    this.parts.add(new LiteralTree[]{literal});
                } else {
                    literals.add(literal);
                }
            } else if (expr.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
                BinaryExpressionTree binExpr = (BinaryExpressionTree)expr;
                this.findInStringConcatenation(binExpr.leftOperand(), literals);
                this.findInStringConcatenation(binExpr.rightOperand(), literals);
            } else if (expr.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
                this.findInStringConcatenation(ExpressionUtils.skipParentheses((ExpressionTree)expr), literals);
            } else {
                this.find(expr);
            }
        }

        private boolean isCommented(LiteralTree regexPart) {
            int line = regexPart.token().line();
            return this.regexContainsComments || RegexComplexityCheck.this.commentedLines.contains(line) || RegexComplexityCheck.this.commentedLines.contains(line - 1);
        }
    }
}

