/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.JavaPropertiesHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5542")
public class EncryptionAlgorithmCheck
extends AbstractMethodDetection {
    private static final Pattern ALGORITHM_PATTERN = Pattern.compile("(.+)/(.+)/(.+)");

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"javax.crypto.Cipher"}).names(new String[]{"getInstance"}).withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Tree declaration;
        ExpressionTree firstArgument;
        if (mit.arguments().isEmpty()) {
            return;
        }
        ExpressionTree algorithmTree = firstArgument = (ExpressionTree)mit.arguments().get(0);
        ArrayList<JavaFileScannerContext.Location> transformationDefinition = new ArrayList<JavaFileScannerContext.Location>();
        ExpressionTree defaultPropertyValue = JavaPropertiesHelper.retrievedPropertyDefaultValue(firstArgument);
        if (defaultPropertyValue != null) {
            algorithmTree = defaultPropertyValue;
            transformationDefinition.add(new JavaFileScannerContext.Location("Default transformation", (Tree)defaultPropertyValue));
        } else if (firstArgument.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (declaration = ((IdentifierTree)firstArgument).symbol().declaration()) != null) {
            transformationDefinition.add(new JavaFileScannerContext.Location("Transformation definition", declaration));
        }
        String algorithmName = ExpressionsHelper.getConstantValueAsString(algorithmTree).value();
        if (algorithmName != null && EncryptionAlgorithmCheck.isInsecureAlgorithm(algorithmName)) {
            this.reportIssue((Tree)firstArgument, "Use secure mode and padding scheme.", transformationDefinition, null);
        }
    }

    private static boolean isInsecureAlgorithm(String algorithmName) {
        Matcher matcher = ALGORITHM_PATTERN.matcher(algorithmName);
        if (matcher.matches()) {
            String algorithm = matcher.group(1);
            String mode = matcher.group(2);
            String padding = matcher.group(3);
            boolean isRSA = "RSA".equalsIgnoreCase(algorithm);
            if ("ECB".equalsIgnoreCase(mode) && !isRSA) {
                return true;
            }
            if ("CBC".equalsIgnoreCase(mode)) {
                return "PKCS5Padding".equalsIgnoreCase(padding) || "PKCS7Padding".equalsIgnoreCase(padding);
            }
            if (isRSA) {
                return !padding.toUpperCase(Locale.ROOT).startsWith("OAEP");
            }
            return false;
        }
        return true;
    }
}

