/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S5344")
public class PasswordEncoderCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers JDBC_AUTHENTICATION = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder"}).names(new String[]{"jdbcAuthentication"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers USER_DETAIL_SERVICE = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder"}).names(new String[]{"userDetailsService"}).withAnyParameters().build();
    private static final MethodMatchers PASSWORD_ENCODER_SETTER = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.security.config.annotation.authentication.configurers.userdetails.AbstractDaoAuthenticationConfigurer"}).names(new String[]{"passwordEncoder"}).withAnyParameters().build();
    private static final MethodMatchers UNSAFE_PASSWORD_ENCODERS = MethodMatchers.create().ofTypes(new String[]{"org.springframework.security.authentication.encoding.ShaPasswordEncoder", "org.springframework.security.authentication.encoding.Md5PasswordEncoder", "org.springframework.security.crypto.password.LdapShaPasswordEncoder", "org.springframework.security.crypto.password.Md4PasswordEncoder", "org.springframework.security.crypto.password.MessageDigestPasswordEncoder", "org.springframework.security.crypto.password.NoOpPasswordEncoder", "org.springframework.security.crypto.password.StandardPasswordEncoder", "org.springframework.security.crypto.password.SCryptPasswordEncoder"}).constructor().withAnyParameters().build();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && UNSAFE_PASSWORD_ENCODERS.matches((NewClassTree)tree)) {
            this.reportIssue((Tree)((NewClassTree)tree).identifier(), "Use secure \"PasswordEncoder\" implementation.");
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            MethodInvocationVisitor visitor = new MethodInvocationVisitor();
            tree.accept((TreeVisitor)visitor);
            if (visitor.hasAuthentication && !visitor.setsPasswordEncoder) {
                this.reportIssue((Tree)visitor.tree, "Don't use the default \"PasswordEncoder\" relying on plain-text.");
            }
        }
    }

    static class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private boolean hasAuthentication;
        private boolean setsPasswordEncoder;
        private MethodInvocationTree tree;

        MethodInvocationVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (JDBC_AUTHENTICATION.matches(tree) || USER_DETAIL_SERVICE.matches(tree)) {
                this.hasAuthentication = true;
                this.tree = tree;
            }
            if (PASSWORD_ENCODER_SETTER.matches(tree)) {
                this.setsPasswordEncoder = true;
            }
            super.visitMethodInvocation(tree);
        }
    }
}

