/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractJUnit5NotCompliantModifierChecker
extends IssuableSubscriptionVisitor {
    protected abstract boolean isNotCompliant(Modifier var1);

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        List testMethods = classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).filter(UnitTestUtils::hasJUnit5TestAnnotation).collect(Collectors.toList());
        testMethods.stream().map(MethodTree::modifiers).forEach(this::raiseIssueOnNotCompliantModifiers);
        if (!testMethods.isEmpty()) {
            this.raiseIssueOnNotCompliantModifiers(classTree.modifiers());
        }
    }

    private void raiseIssueOnNotCompliantModifiers(ModifiersTree modifierTree) {
        modifierTree.modifiers().stream().filter(modifier -> this.isNotCompliant(modifier.modifier())).findFirst().ifPresent(modifier -> this.reportIssue((Tree)modifier, "Remove this '" + modifier.keyword().text() + "' modifier."));
    }
}

