/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.function.Predicate;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

class AssertJChainSimplificationHelper {
    private AssertJChainSimplificationHelper() {
    }

    static boolean hasMethodCallAsArg(ExpressionTree arg, MethodMatchers methodCallMatcher) {
        if (arg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return methodCallMatcher.matches((MethodInvocationTree)arg);
        }
        return false;
    }

    static String msgWithActual(String predicateName) {
        return String.format("assertThat(actual).%s()", predicateName);
    }

    static String msgWithActualExpected(String predicateName) {
        return String.format("assertThat(actual).%s(expected)", predicateName);
    }

    static String msgWithActualCustom(String predicateName, String predicateArg) {
        return String.format("assertThat(actual).%s(%s)", predicateName, predicateArg);
    }

    static class ArgumentHelper {
        private ArgumentHelper() {
        }

        static boolean equalsTo(ExpressionTree expression, Predicate<ExpressionTree> comparedWithPredicate) {
            return expression.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) && ArgumentHelper.leftOrRightIs((BinaryExpressionTree)expression, comparedWithPredicate);
        }

        static boolean notEqualsTo(ExpressionTree expression, Predicate<ExpressionTree> comparedWithPredicate) {
            return expression.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}) && ArgumentHelper.leftOrRightIs((BinaryExpressionTree)expression, comparedWithPredicate);
        }

        static boolean leftOrRightIs(BinaryExpressionTree bet, Predicate<ExpressionTree> sidePredicate) {
            return sidePredicate.test(bet.leftOperand()) || sidePredicate.test(bet.rightOperand());
        }
    }

    static class BooleanFlag {
        private boolean flag = false;

        BooleanFlag() {
        }

        public void setTrue() {
            this.flag = true;
        }

        public boolean value() {
            return this.flag;
        }
    }
}

