/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3415")
public class AssertionArgumentOrderCheck
extends AbstractMethodDetection {
    private static final String ORG_JUNIT_ASSERT = "org.junit.Assert";
    private static final String ORG_JUNIT5_ASSERTIONS = "org.junit.jupiter.api.Assertions";
    private static final Tree.Kind[] LITERAL_KINDS = new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL};
    private static final String MESSAGE_TWO_LITERALS = "Change this assertion to not compare two literals.";
    private static final String MESSAGE_SWAP = "Swap these 2 arguments so they are in the correct order: %s.";
    private static final String MESSAGE_REPLACE = "Replace this literal with the actual expression you want to assert.";
    private static final MethodMatchers COLLECTION_CREATION_CALL = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.util.Collections"}).name(name -> name.startsWith("singleton") || name.startsWith("empty")).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.Arrays"}).names(new String[]{"asList"}).withAnyParameters().build()});

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{ORG_JUNIT_ASSERT}).names(new String[]{"assertEquals", "assertSame", "assertNotSame"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{ORG_JUNIT5_ASSERTIONS}).names(new String[]{"assertArrayEquals", "assertEquals", "assertIterableEquals", "assertLinesMatch", "assertNotEquals", "assertNotSame", "assertSame"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.api.Assertions"}).names(new String[]{"assertThat", "assertThatObject"}).addParametersMatcher(new String[]{"*"}).build()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (mit.symbol().owner().type().is(ORG_JUNIT5_ASSERTIONS)) {
            this.checkArguments((ExpressionTree)mit.arguments().get(0), (ExpressionTree)mit.arguments().get(1), "expected value, actual value");
        } else if (mit.symbol().owner().type().is(ORG_JUNIT_ASSERT)) {
            ExpressionTree argToCheck = AssertionArgumentOrderCheck.getActualArgument(mit);
            this.checkArguments(AssertionArgumentOrderCheck.previousArg(argToCheck, mit), argToCheck, "expected value, actual value");
        } else {
            Optional<ExpressionTree> expectedValue = AssertionArgumentOrderCheck.getExpectedValue(mit);
            ExpressionTree actualValue = (ExpressionTree)mit.arguments().get(0);
            if (expectedValue.isPresent()) {
                this.checkArguments(expectedValue.get(), actualValue, "actual value, expected value");
            } else {
                this.checkArgument(actualValue);
            }
        }
    }

    private void checkArguments(ExpressionTree expectedArgument, ExpressionTree actualArgument, String correctOrder) {
        if (actualArgument.is(LITERAL_KINDS)) {
            if (expectedArgument.is(LITERAL_KINDS)) {
                this.reportIssue(expectedArgument, actualArgument, MESSAGE_TWO_LITERALS);
            } else {
                this.reportIssue(expectedArgument, actualArgument, String.format(MESSAGE_SWAP, correctOrder));
            }
        } else if (AssertionArgumentOrderCheck.isExpectedPattern(actualArgument) && !AssertionArgumentOrderCheck.isExpectedPattern(expectedArgument)) {
            this.reportIssue(expectedArgument, actualArgument, String.format(MESSAGE_SWAP, correctOrder));
        }
    }

    private void checkArgument(ExpressionTree actualArgument) {
        if (actualArgument.is(LITERAL_KINDS)) {
            this.reportIssue((Tree)actualArgument, MESSAGE_REPLACE);
        }
    }

    private static Optional<ExpressionTree> getExpectedValue(MethodInvocationTree mit) {
        return MethodTreeUtils.consecutiveMethodInvocation((Tree)mit).filter(secondInvocation -> {
            Tree parent = secondInvocation.parent();
            return parent != null && parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) && secondInvocation.arguments().size() == 1;
        }).map(secondInvocation -> (ExpressionTree)secondInvocation.arguments().get(0));
    }

    private void reportIssue(ExpressionTree expectedArgument, ExpressionTree actualArgument, String message) {
        List<JavaFileScannerContext.Location> secondaries = Collections.singletonList(new JavaFileScannerContext.Location("", (Tree)expectedArgument));
        this.context.reportIssue((JavaCheck)this, (Tree)actualArgument, message, secondaries, null);
    }

    private static boolean isNewArrayWithConstants(ExpressionTree actualArgument) {
        if (actualArgument.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            NewArrayTree newArrayTree = (NewArrayTree)actualArgument;
            return newArrayTree.initializers().stream().allMatch(AssertionArgumentOrderCheck::isConstant);
        }
        return false;
    }

    private static boolean isCollectionCreationWithConstants(ExpressionTree actualArgument) {
        if (actualArgument.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)actualArgument;
            return COLLECTION_CREATION_CALL.matches(mit) && mit.arguments().stream().allMatch(AssertionArgumentOrderCheck::isConstant);
        }
        return false;
    }

    private static ExpressionTree previousArg(ExpressionTree argToCheck, MethodInvocationTree mit) {
        return (ExpressionTree)mit.arguments().get(mit.arguments().indexOf((Object)argToCheck) - 1);
    }

    private static ExpressionTree getActualArgument(MethodInvocationTree mit) {
        int arity = mit.arguments().size();
        ExpressionTree arg = (ExpressionTree)mit.arguments().get(arity - 1);
        if (arity > 2 && (arity == 4 || ((Symbol.MethodSymbol)mit.symbol()).parameterTypes().stream().allMatch(AssertionArgumentOrderCheck::isDoubleOrFloat))) {
            arg = (ExpressionTree)mit.arguments().get(arity - 2);
        }
        return arg;
    }

    private static boolean isDoubleOrFloat(Type type) {
        return type.isPrimitive(Type.Primitives.DOUBLE) || type.isPrimitive(Type.Primitives.FLOAT);
    }

    private static boolean isExpectedPattern(ExpressionTree actualArgument) {
        return AssertionArgumentOrderCheck.isConstant((Tree)actualArgument) || AssertionArgumentOrderCheck.isNewArrayWithConstants(actualArgument) || AssertionArgumentOrderCheck.isCollectionCreationWithConstants(actualArgument);
    }

    private static boolean isConstant(Tree argToCheck) {
        return argToCheck.is(LITERAL_KINDS) || argToCheck.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && AssertionArgumentOrderCheck.isStaticFinal(((IdentifierTree)argToCheck).symbol()) || argToCheck.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && AssertionArgumentOrderCheck.isStaticFinal(((MemberSelectExpressionTree)argToCheck).identifier().symbol());
    }

    private static boolean isStaticFinal(Symbol symbol) {
        return symbol.isStatic() && symbol.isFinal();
    }
}

