/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S5779")
public class AssertionInTryCatchCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TRY_STATEMENT);
    }

    public void visitNode(Tree tree) {
        TryStatementTree tryStatementTree = (TryStatementTree)tree;
        AssertionInTryCatchCheck.getUnusedCatchAssertionErrorParameter(tryStatementTree.catches()).ifPresent(catchTree -> tryStatementTree.block().accept((TreeVisitor)new TryBodyVisitor((VariableTree)catchTree)));
    }

    private static Optional<VariableTree> getUnusedCatchAssertionErrorParameter(List<CatchTree> catches) {
        return catches.stream().map(CatchTree::parameter).filter(param -> {
            Type symbolType = param.type().symbolType();
            return param.symbol().usages().isEmpty() && (symbolType.isSubtypeOf("java.lang.AssertionError") || symbolType.is("java.lang.Error") || symbolType.is("java.lang.Throwable"));
        }).findFirst();
    }

    private class TryBodyVisitor
    extends BaseTreeVisitor {
        private final List<JavaFileScannerContext.Location> secondaryLocation;

        public TryBodyVisitor(VariableTree catchTree) {
            this.secondaryLocation = Collections.singletonList(new JavaFileScannerContext.Location("This parameter will catch the AssertionError", (Tree)catchTree.type()));
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            if (UnitTestUtils.COMMON_ASSERTION_MATCHER.matches(methodInvocation)) {
                IdentifierTree identifier = ExpressionUtils.methodName((MethodInvocationTree)methodInvocation);
                AssertionInTryCatchCheck.this.reportIssue((Tree)identifier, String.format("Don't use %s() inside a try-catch catching an AssertionError.", identifier.name()), this.secondaryLocation, null);
            }
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }
    }
}

