/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2187")
public class NoTestInTestClassCheck
extends IssuableSubscriptionVisitor {
    public static final String ARCH_UNIT_RUNNER = "ArchUnitRunner";
    public static final String ARCH_UNIT_ANALYZE_CLASSES = "com.tngtech.archunit.junit.AnalyzeClasses";
    public static final String ARCH_UNIT_TEST = "com.tngtech.archunit.junit.ArchTest";
    private final Set<String> testMethodAnnotations = new HashSet<String>();
    private final Set<String> testFieldAnnotations = new HashSet<String>();
    private final Set<String> seenAnnotations = new HashSet<String>();
    private static final String DEFAULT_TEST_CLASS_NAME_PATTERN = ".*(Test|Tests|TestCase)";
    @RuleProperty(key="TestClassNamePattern", description="Test class name pattern (regular expression)", defaultValue=".*(Test|Tests|TestCase)")
    public String testClassNamePattern = ".*(Test|Tests|TestCase)";
    private Pattern testClassNamePatternRegEx;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            this.resetAnnotationCache();
            CompilationUnitTree cut = (CompilationUnitTree)tree;
            cut.types().stream().filter(typeTree -> typeTree.is(new Tree.Kind[]{Tree.Kind.CLASS})).forEach(typeTree -> this.checkClass((ClassTree)typeTree));
        }
    }

    private void resetAnnotationCache() {
        this.testMethodAnnotations.clear();
        this.testFieldAnnotations.clear();
        this.seenAnnotations.clear();
        this.testMethodAnnotations.add("org.junit.Test");
        this.testMethodAnnotations.add("org.testng.annotations.Test");
        this.testMethodAnnotations.add("org.junit.jupiter.api.Test");
    }

    private void checkClass(ClassTree classTree) {
        if (!ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            Symbol.TypeSymbol classSymbol = classTree.symbol();
            Stream<Symbol> members = NoTestInTestClassCheck.getAllMembers(classSymbol, NoTestInTestClassCheck.checkRunWith(classSymbol, "Enclosed"));
            IdentifierTree simpleName = classTree.simpleName();
            if (classSymbol.metadata().isAnnotatedWith("org.testng.annotations.Test")) {
                this.checkTestNGmembers(simpleName, members);
            } else {
                boolean isJunit3TestClass = classSymbol.type().isSubtypeOf("junit.framework.TestCase");
                List<Symbol> membersList = members.collect(Collectors.toList());
                if (isJunit3TestClass && NoTestInTestClassCheck.containsJUnit3Tests(membersList)) {
                    return;
                }
                if (isJunit3TestClass || this.isTestClassName(classSymbol.name())) {
                    this.checkJunit4AndAboveTestClass(simpleName, classSymbol, membersList);
                }
            }
        }
    }

    private boolean isTestClassName(String className) {
        if (StringUtils.isEmpty((String)this.testClassNamePattern)) {
            return false;
        }
        if (this.testClassNamePatternRegEx == null) {
            this.testClassNamePatternRegEx = Pattern.compile(this.testClassNamePattern);
        }
        return this.testClassNamePatternRegEx.matcher(className).matches();
    }

    private static boolean isArchUnitTestClass(Symbol.TypeSymbol classSymbol) {
        return NoTestInTestClassCheck.checkRunWith(classSymbol, ARCH_UNIT_RUNNER) || classSymbol.metadata().isAnnotatedWith(ARCH_UNIT_ANALYZE_CLASSES);
    }

    private void checkTestNGmembers(IdentifierTree className, Stream<Symbol> members) {
        if (members.noneMatch(member -> member.isMethodSymbol() && member.isPublic() && !member.isStatic() && !"<init>".equals(member.name()))) {
            this.reportClass(className);
        }
    }

    private static boolean containsJUnit3Tests(List<Symbol> members) {
        return members.stream().anyMatch(m -> m.isMethodSymbol() && m.name().startsWith("test"));
    }

    private void checkJunit4AndAboveTestClass(IdentifierTree className, Symbol.TypeSymbol symbol, List<Symbol> members) {
        this.addUsedAnnotations(symbol);
        if (!NoTestInTestClassCheck.runWithCucumberOrSuiteOrTheoriesRunner(symbol) && members.stream().noneMatch(this::isTestFieldOrMethod)) {
            this.reportClass(className);
        }
    }

    private void addUsedAnnotations(Symbol.TypeSymbol classSymbol) {
        if (NoTestInTestClassCheck.runWitZohhak(classSymbol)) {
            this.testMethodAnnotations.add("com.googlecode.zohhak.api.TestWith");
        } else if (NoTestInTestClassCheck.isArchUnitTestClass(classSymbol)) {
            this.testMethodAnnotations.add(ARCH_UNIT_TEST);
            this.testFieldAnnotations.add(ARCH_UNIT_TEST);
        }
    }

    private static boolean runWithCucumberOrSuiteOrTheoriesRunner(Symbol.TypeSymbol symbol) {
        return NoTestInTestClassCheck.checkRunWith(symbol, "Cucumber", "Suite", "Theories");
    }

    private static boolean runWitZohhak(Symbol.TypeSymbol symbol) {
        return NoTestInTestClassCheck.checkRunWith(symbol, "ZohhakRunner");
    }

    private static boolean checkRunWith(Symbol.TypeSymbol symbol, String ... runnerClasses) {
        List annotationValues = symbol.metadata().valuesForAnnotation("org.junit.runner.RunWith");
        if (annotationValues != null && annotationValues.size() == 1) {
            Object value = ((SymbolMetadata.AnnotationValue)annotationValues.get(0)).value();
            return value instanceof Symbol.TypeSymbol && NoTestInTestClassCheck.checkRunWithType((Symbol.TypeSymbol)value, runnerClasses);
        }
        return false;
    }

    private static boolean checkRunWithType(Symbol.TypeSymbol value, String ... runnerClasses) {
        for (String runnerClass : runnerClasses) {
            if (!runnerClass.equals(value.name())) continue;
            return true;
        }
        return false;
    }

    private boolean isTestFieldOrMethod(Symbol member) {
        return member.metadata().annotations().stream().anyMatch(input -> {
            Type type = input.symbol().type();
            return type.isUnknown() || member.isMethodSymbol() && this.isTestMethodAnnotation(type) || member.isVariableSymbol() && this.testFieldAnnotations.contains(type.fullyQualifiedName());
        });
    }

    private boolean isTestMethodAnnotation(Type type) {
        return this.testMethodAnnotations.contains(type.fullyQualifiedName()) || this.isJUnitTestableMetaAnnotated(type);
    }

    private boolean isJUnitTestableMetaAnnotated(Type type) {
        if (this.seenAnnotations.contains(type.fullyQualifiedName())) {
            return false;
        }
        this.seenAnnotations.add(type.fullyQualifiedName());
        SymbolMetadata metadata = type.symbol().metadata();
        if (metadata.isAnnotatedWith("org.junit.platform.commons.annotation.Testable")) {
            this.testMethodAnnotations.add(type.fullyQualifiedName());
            return true;
        }
        for (SymbolMetadata.AnnotationInstance annotation : metadata.annotations()) {
            if (!this.isJUnitTestableMetaAnnotated(annotation.symbol().type())) continue;
            this.testMethodAnnotations.add(type.fullyQualifiedName());
            return true;
        }
        return false;
    }

    private static Stream<Symbol> getAllMembers(Symbol.TypeSymbol symbol, boolean isEnclosed) {
        return NoTestInTestClassCheck.getAllMembers(symbol, isEnclosed, new HashSet<Symbol>());
    }

    private static Stream<Symbol> getAllMembers(Symbol.TypeSymbol symbol, boolean isEnclosed, Set<Symbol> visitedSymbols) {
        Type superClass;
        if (!visitedSymbols.add((Symbol)symbol) || symbol.type().is("java.lang.Object")) {
            return Stream.empty();
        }
        Stream<Symbol> members = Stream.empty();
        if (!isEnclosed) {
            members = symbol.memberSymbols().stream().filter(m -> m.isMethodSymbol() || m.isVariableSymbol());
        }
        if ((superClass = symbol.superClass()) != null) {
            members = Stream.concat(members, NoTestInTestClassCheck.getAllMembers(superClass.symbol(), isEnclosed, visitedSymbols));
        }
        Stream<Symbol> defaultMethodsFromInterfaces = symbol.interfaces().stream().flatMap(i -> NoTestInTestClassCheck.getAllMembers(i.symbol(), false, visitedSymbols)).filter(m -> m.isMethodSymbol() && JUtils.isDefaultMethod((Symbol.MethodSymbol)((Symbol.MethodSymbol)m)));
        members = Stream.concat(members, defaultMethodsFromInterfaces);
        for (Symbol s : symbol.memberSymbols()) {
            if (!NoTestInTestClassCheck.isNested(s) && !NoTestInTestClassCheck.isPublicStaticConcrete(s)) continue;
            members = Stream.concat(members, NoTestInTestClassCheck.getAllMembers((Symbol.TypeSymbol)s, false, visitedSymbols));
        }
        return members;
    }

    private static boolean isNested(Symbol s) {
        return s.isTypeSymbol() && s.metadata().isAnnotatedWith("org.junit.jupiter.api.Nested");
    }

    private static boolean isPublicStaticConcrete(Symbol s) {
        return NoTestInTestClassCheck.isPublicStaticClass(s) && !s.isAbstract();
    }

    private static boolean isPublicStaticClass(Symbol symbol) {
        return symbol.isTypeSymbol() && symbol.isPublic() && symbol.isStatic();
    }

    private void reportClass(IdentifierTree className) {
        this.reportIssue((Tree)className, "Add some tests to this class.");
    }
}

