/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.hibernate;

import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Rule(key="S3822")
public class DatabaseSchemaUpdateCheck
extends SimpleXPathBasedCheck {
    private XPathExpression hibernateHbm2ddlAutoProperty = this.getXPathExpression("//property[@name='hibernate.hbm2ddl.auto']");

    public void scanFile(XmlFile file) {
        this.evaluateAsList(this.hibernateHbm2ddlAutoProperty, file.getNamespaceUnawareDocument()).forEach(this::checkProperty);
    }

    private void checkProperty(Node property) {
        String value;
        NodeList children = property.getChildNodes();
        if (children.getLength() == 1 && !"none".equals(value = children.item(0).getNodeValue().trim()) && !"validate".equals(value)) {
            this.reportIssue(property, "Use \"validate\" or remove this property.");
        }
    }
}

