/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1166")
public class CatchUsesExceptionWithContextCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final MethodMatchers GET_MESSAGE_METHODS = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Throwable"}).names(new String[]{"getMessage", "getLocalizedMessage"}).addWithoutParametersMatcher().build();
    private static final String JAVA_UTIL_LOGGING_LOGGER = "java.util.logging.Logger";
    private static final String SLF4J_LOGGER = "org.slf4j.Logger";
    private static final MethodMatchers JAVA_UTIL_LOG_METHOD = MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(new String[]{"log"}).withAnyParameters().build();
    private static final MethodMatchers JAVA_UTIL_LOGP_METHOD = MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(new String[]{"logp"}).withAnyParameters().build();
    private static final MethodMatchers JAVA_UTIL_LOGRB_METHOD = MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(new String[]{"logrb"}).withAnyParameters().build();
    private static final MethodMatchers LOGGING_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofAnyType().name(CatchUsesExceptionWithContextCheck::containsLogIgnoreCase).withAnyParameters().build(), MethodMatchers.create().ofType(type -> CatchUsesExceptionWithContextCheck.containsLogIgnoreCase(type.name())).anyName().withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(new String[]{"config", "fine", "finer", "finest", "info", "severe", "warning"}).withAnyParameters().build(), JAVA_UTIL_LOG_METHOD, JAVA_UTIL_LOGP_METHOD, JAVA_UTIL_LOGRB_METHOD, MethodMatchers.create().ofTypes(new String[]{"org.slf4j.Logger"}).names(new String[]{"debug", "error", "info", "trace", "warn"}).withAnyParameters().build()});
    private static final String EXCLUDED_EXCEPTION_TYPE = "java.lang.InterruptedException, java.lang.NumberFormatException, java.lang.NoSuchMethodException, java.text.ParseException, java.net.MalformedURLException, java.time.format.DateTimeParseException";
    @RuleProperty(key="exceptions", description="List of exceptions which should not be checked. Use a simple dash ('-') character to check all exceptions.", defaultValue="java.lang.InterruptedException, java.lang.NumberFormatException, java.lang.NoSuchMethodException, java.text.ParseException, java.net.MalformedURLException, java.time.format.DateTimeParseException")
    public String exceptionsCommaSeparated = "java.lang.InterruptedException, java.lang.NumberFormatException, java.lang.NoSuchMethodException, java.text.ParseException, java.net.MalformedURLException, java.time.format.DateTimeParseException";
    private JavaFileScannerContext context;
    private Deque<UsageStatus> usageStatusStack;
    private Set<String> exceptions;
    private Set<String> exceptionIdentifiers;
    private Set<CatchTree> excludedCatchTrees = new HashSet<CatchTree>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.usageStatusStack = new ArrayDeque<UsageStatus>();
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
        this.excludedCatchTrees.clear();
    }

    public void visitTryStatement(TryStatementTree tree) {
        if (CatchUsesExceptionWithContextCheck.containsEnumValueOf((Tree)tree.block())) {
            tree.catches().stream().filter(c -> c.parameter().symbol().type().is("java.lang.IllegalArgumentException")).findAny().ifPresent(this.excludedCatchTrees::add);
        }
        super.visitTryStatement(tree);
    }

    private static boolean containsEnumValueOf(Tree tree) {
        EnumValueOfVisitor visitor = new EnumValueOfVisitor();
        tree.accept((TreeVisitor)visitor);
        return visitor.hasEnumValueOf;
    }

    private static boolean containsLogIgnoreCase(String name) {
        return StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"log");
    }

    public void visitCatch(CatchTree tree) {
        if (!this.isExcludedType((Tree)tree.parameter().type()) && !this.excludedCatchTrees.contains(tree)) {
            Symbol exception = tree.parameter().symbol();
            this.usageStatusStack.addFirst(new UsageStatus(exception.usages()));
            super.visitCatch(tree);
            if (this.usageStatusStack.pop().isInvalid()) {
                this.context.reportIssue((JavaCheck)this, (Tree)tree.parameter(), "Either log or rethrow this exception.");
            }
        }
    }

    public void visitMethodInvocation(MethodInvocationTree mit) {
        super.visitMethodInvocation(mit);
        if (LOGGING_METHODS.matches(mit) || mit.methodSymbol().isUnknown()) {
            this.usageStatusStack.forEach(usageStatus -> usageStatus.addLoggingMethodInvocation(mit));
        }
    }

    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        ExpressionTree expression = tree.expression();
        Object identifier = expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? (IdentifierTree)expression : (expression.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION}) && ((ParenthesizedTree)expression).expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? (IdentifierTree)((ParenthesizedTree)expression).expression() : null);
        if (!this.usageStatusStack.isEmpty() && identifier != null) {
            this.usageStatusStack.forEach(arg_0 -> CatchUsesExceptionWithContextCheck.lambda$visitMemberSelectExpression$3((IdentifierTree)identifier, arg_0));
        }
        super.visitMemberSelectExpression(tree);
    }

    private boolean isExcludedType(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.UNION_TYPE})) {
            return ((UnionTypeTree)tree).typeAlternatives().stream().allMatch(this::isExcludedType);
        }
        return this.isUnqualifiedExcludedType(tree) || this.isQualifiedExcludedType(tree);
    }

    private boolean isUnqualifiedExcludedType(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.getExceptionIdentifiers().contains(((IdentifierTree)tree).name());
    }

    private boolean isQualifiedExcludedType(Tree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return false;
        }
        return this.getExceptions().contains(ExpressionsHelper.concatenate((ExpressionTree)((MemberSelectExpressionTree)tree)));
    }

    private Set<String> getExceptions() {
        if (this.exceptions == null) {
            this.exceptions = "-".equals(this.exceptionsCommaSeparated.trim()) ? Collections.emptySet() : Stream.of(this.exceptionsCommaSeparated.split(",")).map(String::trim).collect(Collectors.toSet());
        }
        return this.exceptions;
    }

    private Set<String> getExceptionIdentifiers() {
        if (this.exceptionIdentifiers == null) {
            this.exceptionIdentifiers = this.getExceptions().stream().map(exception -> exception.substring(exception.lastIndexOf(46) + 1)).collect(Collectors.toSet());
        }
        return this.exceptionIdentifiers;
    }

    private static /* synthetic */ void lambda$visitMemberSelectExpression$3(IdentifierTree identifier, UsageStatus usageStatus) {
        usageStatus.addInvalidUsage(identifier);
    }

    private static class EnumValueOfVisitor
    extends BaseTreeVisitor {
        private static final MethodMatchers ENUM_VALUE_OF = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Enum"}).names(new String[]{"valueOf"}).withAnyParameters().build();
        private boolean hasEnumValueOf = false;

        private EnumValueOfVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (ENUM_VALUE_OF.matches(tree)) {
                this.hasEnumValueOf = true;
            }
            super.visitMethodInvocation(tree);
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }
    }

    private static class UsageStatus {
        private final Collection<IdentifierTree> validUsages;
        private final List<MethodInvocationTree> loggingMethodInvocations;

        UsageStatus(Collection<IdentifierTree> usages) {
            this.validUsages = new ArrayList<IdentifierTree>(usages);
            this.loggingMethodInvocations = new ArrayList<MethodInvocationTree>();
        }

        public void addInvalidUsage(IdentifierTree exceptionIdentifier) {
            this.validUsages.remove(exceptionIdentifier);
        }

        public void addLoggingMethodInvocation(MethodInvocationTree mit) {
            this.loggingMethodInvocations.add(mit);
        }

        public boolean isInvalid() {
            return this.validUsages.isEmpty() && !this.isMessageLoggedWithAdditionalContext();
        }

        private boolean isMessageLoggedWithAdditionalContext() {
            return this.loggingMethodInvocations.stream().anyMatch(mit -> UsageStatus.hasGetMessageInvocation(mit) && UsageStatus.hasDynamicExceptionMessageUsage(mit));
        }

        private static boolean hasGetMessageInvocation(MethodInvocationTree mit) {
            return UsageStatus.hasGetMessageMethodInvocation((Tree)mit) || UsageStatus.isGetMessageReferencedByIdentifiers(mit);
        }

        private static boolean isGetMessageReferencedByIdentifiers(MethodInvocationTree mit) {
            ChildrenIdentifierCollector visitor = new ChildrenIdentifierCollector();
            mit.accept((TreeVisitor)visitor);
            boolean invocationInInitializer = visitor.identifiersChildren.stream().map(UsageStatus::getVariableInitializer).distinct().anyMatch(UsageStatus::hasGetMessageMethodInvocation);
            return invocationInInitializer || visitor.identifiersChildren.stream().map(IdentifierTree::symbol).map(Symbol::usages).flatMap(usagesList -> UsageStatus.getAssignments(usagesList).stream()).anyMatch(assignment -> UsageStatus.hasGetMessageMethodInvocation((Tree)assignment.expression()));
        }

        private static boolean hasGetMessageMethodInvocation(@Nullable Tree tree) {
            if (tree == null) {
                return false;
            }
            GetExceptionMessageVisitor visitor = new GetExceptionMessageVisitor();
            tree.accept((TreeVisitor)visitor);
            return visitor.hasGetMessageCall;
        }

        private static boolean hasDynamicExceptionMessageUsage(MethodInvocationTree mit) {
            Arguments arguments = mit.arguments();
            int argumentsCount = arguments.size();
            if (argumentsCount == 0) {
                return true;
            }
            ExpressionTree firstArg = (ExpressionTree)arguments.get(0);
            Object argumentToCheck = mit.methodSymbol().owner().type().is(CatchUsesExceptionWithContextCheck.SLF4J_LOGGER) ? (argumentsCount == 1 ? firstArg : (argumentsCount == 2 && firstArg.symbolType().is("org.slf4j.Marker") ? (ExpressionTree)arguments.get(1) : null)) : (JAVA_UTIL_LOG_METHOD.matches(mit) && argumentsCount == 2 ? (ExpressionTree)arguments.get(1) : (JAVA_UTIL_LOGP_METHOD.matches(mit) && argumentsCount == 4 ? (ExpressionTree)arguments.get(3) : (JAVA_UTIL_LOGRB_METHOD.matches(mit) && argumentsCount == 5 ? (ExpressionTree)arguments.get(4) : firstArg)));
            return argumentToCheck == null || !UsageStatus.isSimpleExceptionMessage(argumentToCheck);
        }

        private static boolean isSimpleExceptionMessage(ExpressionTree expressionTree) {
            ExpressionTree innerExpression = ExpressionUtils.skipParentheses((ExpressionTree)expressionTree);
            if (innerExpression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree variable = (IdentifierTree)innerExpression;
                List<AssignmentExpressionTree> assignments = UsageStatus.getAssignments(variable.symbol().usages());
                ExpressionTree initializer = UsageStatus.getVariableInitializer(variable);
                return assignments.isEmpty() && initializer != null && UsageStatus.isSimpleExceptionMessage(initializer);
            }
            if (innerExpression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                return GET_MESSAGE_METHODS.matches((MethodInvocationTree)innerExpression);
            }
            return false;
        }

        private static List<AssignmentExpressionTree> getAssignments(List<IdentifierTree> usages) {
            return usages.stream().map(UsageStatus::getAssignmentToIdentifier).filter(Objects::nonNull).collect(Collectors.toList());
        }

        @CheckForNull
        private static AssignmentExpressionTree getAssignmentToIdentifier(IdentifierTree usage) {
            for (Tree parent = usage.parent(); parent != null; parent = parent.parent()) {
                if (!parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT})) continue;
                AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)parent;
                if (assignmentExpressionTree.variable().equals((Object)usage)) {
                    return assignmentExpressionTree;
                }
                return null;
            }
            return null;
        }

        @CheckForNull
        private static ExpressionTree getVariableInitializer(IdentifierTree variable) {
            Tree declaration = variable.symbol().declaration();
            if (declaration != null && declaration.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                return ((VariableTree)declaration).initializer();
            }
            return null;
        }
    }

    private static class ChildrenIdentifierCollector
    extends BaseTreeVisitor {
        Set<IdentifierTree> identifiersChildren = new HashSet<IdentifierTree>();

        private ChildrenIdentifierCollector() {
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.identifiersChildren.add(tree);
        }
    }

    private static class GetExceptionMessageVisitor
    extends BaseTreeVisitor {
        boolean hasGetMessageCall = false;

        private GetExceptionMessageVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (!this.hasGetMessageCall && GET_MESSAGE_METHODS.matches(mit)) {
                this.hasGetMessageCall = true;
            }
            super.visitMethodInvocation(mit);
        }

        public void visitNewClass(NewClassTree newClassTree) {
        }
    }
}

