/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3400")
public class ConstantMethodCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        ExpressionTree returnedExpression;
        StatementTree uniqueStatement;
        boolean hasAnnotations;
        MethodTree methodTree = (MethodTree)tree;
        BlockTree body = methodTree.block();
        boolean isSingleStatementMethod = body != null && body.body().size() == 1;
        boolean bl = hasAnnotations = !methodTree.modifiers().annotations().isEmpty();
        if (!isSingleStatementMethod || hasAnnotations) {
            return;
        }
        if (ConstantMethodCheck.isEffectivelyFinal(methodTree) && Boolean.FALSE.equals(methodTree.isOverriding()) && (uniqueStatement = (StatementTree)body.body().get(0)).is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT}) && ConstantMethodCheck.isConstant(returnedExpression = ((ReturnStatementTree)uniqueStatement).expression())) {
            this.reportIssue((Tree)returnedExpression, "Remove this method and declare a constant for this value.");
        }
    }

    private static boolean isEffectivelyFinal(MethodTree methodTree) {
        Tree methodParent = methodTree.parent();
        if (!(methodParent instanceof ClassTree) || methodParent.is(new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE, Tree.Kind.INTERFACE})) {
            return false;
        }
        if (methodParent.is(new Tree.Kind[]{Tree.Kind.RECORD}) || ((ClassTree)methodParent).symbol().isFinal()) {
            return true;
        }
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        return methodSymbol.isFinal() || methodSymbol.isPrivate() || methodSymbol.isStatic();
    }

    private static boolean isConstant(@Nullable ExpressionTree returnedExpression) {
        return returnedExpression != null && returnedExpression.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.TEXT_BLOCK, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.BOOLEAN_LITERAL});
    }
}

