/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S4838")
public class ForLoopVariableTypeCheck
extends IssuableSubscriptionVisitor {
    private static final String PRIMARY_MESSAGE = "Change \"%s\" to the type handled by the Collection.";
    private static final String SECONDARY_MESSAGE = "Collection item type is \"%s\"";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.FOR_EACH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ForEachStatement actualStatement = (ForEachStatement)tree;
        Type variableType = actualStatement.variable().type().symbolType();
        Type collectionItemType = ForLoopVariableTypeCheck.getCollectionItemType(actualStatement.expression());
        if (collectionItemType == null || collectionItemType.isUnknown() || variableType.isUnknown()) {
            return;
        }
        if (!ForLoopVariableTypeCheck.isMostPreciseType(variableType, collectionItemType)) {
            DownCastVisitor downCastVisitor = new DownCastVisitor(actualStatement.variable().symbol());
            actualStatement.statement().accept((TreeVisitor)downCastVisitor);
            if (downCastVisitor.hasDownCastOfLoopVariable) {
                List<JavaFileScannerContext.Location> locations = Collections.singletonList(new JavaFileScannerContext.Location(String.format(SECONDARY_MESSAGE, collectionItemType.name()), (Tree)actualStatement.expression()));
                this.reportIssue((Tree)actualStatement.variable().type(), String.format(PRIMARY_MESSAGE, variableType.name()), locations, 0);
            }
        }
    }

    @CheckForNull
    private static Type getCollectionItemType(ExpressionTree expression) {
        Type expressionType = expression.symbolType();
        if (expressionType.isSubtypeOf("java.util.Collection") && !expressionType.isParameterized()) {
            return null;
        }
        if (expressionType.isArray()) {
            return ((Type.ArrayType)expressionType).elementType();
        }
        if (expressionType.isClass()) {
            return JUtils.superTypes((Symbol.TypeSymbol)expressionType.symbol()).stream().filter(t -> t.is("java.lang.Iterable") && t.isParameterized()).findFirst().map(iter -> (Type)iter.typeArguments().get(0)).orElse(null);
        }
        return null;
    }

    private static boolean isMostPreciseType(Type variableType, Type collectionItemType) {
        return variableType.erasure().equals((Object)collectionItemType.erasure());
    }

    private static class DownCastVisitor
    extends BaseTreeVisitor {
        private final Symbol symbol;
        private boolean hasDownCastOfLoopVariable;

        private DownCastVisitor(Symbol symbol) {
            this.symbol = symbol;
            this.hasDownCastOfLoopVariable = false;
        }

        public void visitTypeCast(TypeCastTree tree) {
            if (this.hasDownCastOfLoopVariable) {
                return;
            }
            ExpressionTree expression = tree.expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ((IdentifierTree)expression).symbol().equals((Object)this.symbol)) {
                this.hasDownCastOfLoopVariable = true;
            } else {
                super.visitTypeCast(tree);
            }
        }
    }
}

