/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S2201")
public class IgnoredReturnValueCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_UTIL_FUNCTION_SUPPLIER = "java.util.function.Supplier";
    private static final String JAVA_UTIL_STREAM_STREAM = "java.util.stream.Stream";
    private static final String COLLECT = "collect";
    private static final List<String> CHECKED_TYPES = Arrays.asList("java.lang.String", "java.lang.Boolean", "java.lang.Integer", "java.lang.Double", "java.lang.Float", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.StackTraceElement", "java.time.DayOfWeek", "java.time.Duration", "java.time.Instant", "java.time.LocalDate", "java.time.LocalDateTime", "java.time.LocalTime", "java.time.Month", "java.time.MonthDay", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.Period", "java.time.Year", "java.time.YearMonth", "java.time.ZonedDateTime", "java.math.BigInteger", "java.math.BigDecimal", "java.util.Optional", "com.google.common.base.Optional");
    private static final List<String> EXCLUDED_PREFIX = Arrays.asList("parse", "format", "decode", "valueOf");
    private static final MethodMatchers EXCLUDED = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.lang.Character"}).names(new String[]{"toChars"}).addParametersMatcher(new String[]{"int", "char[]", "int"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"intern"}).addWithoutParametersMatcher().build()});
    private static final MethodMatchers STRING_GET_BYTES = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"getBytes"}).addParametersMatcher(new String[]{"java.nio.charset.Charset"}).build();
    private static final MethodMatchers COLLECTION_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"java.util.Collection"}).names(new String[]{"size", "isEmpty", "contains", "containsAll", "iterator"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.util.Collection"}).names(new String[]{"toArray"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.util.Map"}).names(new String[]{"get", "getOrDefault", "size", "isEmpty", "containsKey", "containsValue", "keySet", "entrySet", "values"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.util.stream.Stream"}).names(new String[]{"collect", "toArray", "reduce", "min", "max", "count", "anyMatch", "allMatch", "noneMatch", "findFirst", "findAny", "toList"}).withAnyParameters().build()});
    private static final MethodMatchers COLLECT_WITH_COLLECTOR = MethodMatchers.create().ofSubTypes(new String[]{"java.util.stream.Stream"}).names(new String[]{"collect"}).addParametersMatcher(new String[]{"java.util.stream.Collector"}).build();
    private static final MethodMatchers COLLECT_WITH_FUNCTIONS = MethodMatchers.create().ofSubTypes(new String[]{"java.util.stream.Stream"}).names(new String[]{"collect"}).addParametersMatcher(new String[]{"java.util.function.Supplier", "java.util.function.BiConsumer", "java.util.function.BiConsumer"}).build();
    private static final MethodMatchers TO_COLLECTION = MethodMatchers.create().ofSubTypes(new String[]{"java.util.stream.Collectors"}).names(new String[]{"toCollection"}).addParametersMatcher(new String[]{"java.util.function.Supplier"}).build();
    private static final MethodMatchers TO_MAP_WITH_SUPPLIER = MethodMatchers.create().ofSubTypes(new String[]{"java.util.stream.Collectors"}).names(new String[]{"toMap"}).addParametersMatcher(new String[]{"java.util.function.Function", "java.util.function.Function", "java.util.function.BinaryOperator", "java.util.function.Supplier"}).build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ExpressionTree expr = ((ExpressionStatementTree)tree).expression();
        if (expr.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)expr;
            if (IgnoredReturnValueCheck.isExcluded(mit)) {
                return;
            }
            if (IgnoredReturnValueCheck.shouldUseReturnValue(mit)) {
                IdentifierTree methodName = ExpressionUtils.methodName((MethodInvocationTree)mit);
                this.reportIssue((Tree)methodName, "The return value of \"" + methodName.name() + "\" must be used.");
            }
        }
    }

    private static boolean shouldUseReturnValue(MethodInvocationTree mit) {
        Symbol.MethodSymbol symbol = mit.methodSymbol();
        return !IgnoredReturnValueCheck.isVoidOrUnknown(mit.symbolType()) && !IgnoredReturnValueCheck.isConstructor((Symbol)symbol) && symbol.isPublic() && (IgnoredReturnValueCheck.isCheckedType(symbol.owner().type()) || COLLECTION_METHODS.matches((Symbol)symbol));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isExcluded(MethodInvocationTree mit) {
        String methodName = mit.methodSymbol().name();
        if (mit.methodSymbol().isUnknown()) return true;
        if (EXCLUDED.matches(mit)) return true;
        if (IgnoredReturnValueCheck.mayBeCollectingIntoVariable(mit)) return true;
        if (!IgnoredReturnValueCheck.isInTryCatch(mit)) return false;
        if (EXCLUDED_PREFIX.stream().anyMatch(methodName::startsWith)) return true;
        if (!STRING_GET_BYTES.matches(mit)) return false;
        return true;
    }

    private static boolean mayBeCollectingIntoVariable(MethodInvocationTree mit) {
        if (COLLECT_WITH_FUNCTIONS.matches(mit)) {
            return !IgnoredReturnValueCheck.isConstructor((ExpressionTree)mit.arguments().get(0));
        }
        if (COLLECT_WITH_COLLECTOR.matches(mit)) {
            ExpressionTree arg = (ExpressionTree)mit.arguments().get(0);
            if (!arg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                return false;
            }
            MethodInvocationTree collector = (MethodInvocationTree)arg;
            if (TO_COLLECTION.matches(collector)) {
                return !IgnoredReturnValueCheck.isConstructor((ExpressionTree)collector.arguments().get(0));
            }
            if (TO_MAP_WITH_SUPPLIER.matches(collector)) {
                return !IgnoredReturnValueCheck.isConstructor((ExpressionTree)collector.arguments().get(3));
            }
        }
        return false;
    }

    private static boolean isConstructor(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_REFERENCE})) {
            return "new".equals(((MethodReferenceTree)tree).method().name());
        }
        return tree.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION}) && ((LambdaExpressionTree)tree).body().is(new Tree.Kind[]{Tree.Kind.NEW_CLASS, Tree.Kind.NEW_ARRAY});
    }

    private static boolean isInTryCatch(MethodInvocationTree mit) {
        Tree parent;
        for (parent = mit.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT}); parent = parent.parent()) {
        }
        return parent != null && !((TryStatementTree)parent).catches().isEmpty();
    }

    private static boolean isCheckedType(Type ownerType) {
        return CHECKED_TYPES.stream().anyMatch(arg_0 -> ((Type)ownerType).is(arg_0));
    }

    private static boolean isVoidOrUnknown(Type methodType) {
        return methodType.isVoid() || methodType.isUnknown();
    }

    private static boolean isConstructor(Symbol methodSymbol) {
        return "<init>".equals(methodSymbol.name());
    }
}

