/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2674")
public class IgnoredStreamReturnValueCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers MATCHERS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"java.io.InputStream"}).names(new String[]{"skip"}).addParametersMatcher(new String[]{"long"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"java.io.InputStream"}).names(new String[]{"read"}).addParametersMatcher(new String[]{"byte[]"}).build()});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit;
        ExpressionTree statement = ((ExpressionStatementTree)tree).expression();
        if (statement.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && MATCHERS.matches(mit = (MethodInvocationTree)statement)) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Check the return value of the \"" + mit.methodSymbol().name() + "\" call to see how many bytes were read.");
        }
    }
}

