/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S6201")
public class InstanceOfPatternMatchingCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.IF_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.CONDITIONAL_EXPRESSION);
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava16Compatible();
    }

    public void visitNode(Tree tree) {
        switch (tree.kind()) {
            case IF_STATEMENT: {
                IfStatementTree ifStatement = (IfStatementTree)tree;
                this.handleConditional(ifStatement.condition(), (Tree)ifStatement.thenStatement(), (Tree)ifStatement.elseStatement());
                break;
            }
            case FOR_STATEMENT: {
                ForStatementTree forStatement = (ForStatementTree)tree;
                if (forStatement.condition() == null) break;
                this.handleConditional(forStatement.condition(), (Tree)forStatement.statement(), null);
                break;
            }
            case WHILE_STATEMENT: {
                WhileStatementTree whileStatement = (WhileStatementTree)tree;
                this.handleConditional(whileStatement.condition(), (Tree)whileStatement.statement(), null);
                break;
            }
            case CONDITIONAL_AND: {
                BinaryExpressionTree and = (BinaryExpressionTree)tree;
                this.handleConditional(and.leftOperand(), (Tree)and.rightOperand(), null);
                break;
            }
            case CONDITIONAL_OR: {
                BinaryExpressionTree or = (BinaryExpressionTree)tree;
                this.handleConditional(or.leftOperand(), null, (Tree)or.rightOperand());
                break;
            }
            default: {
                ConditionalExpressionTree conditional = (ConditionalExpressionTree)tree;
                this.handleConditional(conditional.condition(), (Tree)conditional.trueExpression(), (Tree)conditional.falseExpression());
            }
        }
    }

    private void handleConditional(ExpressionTree condition, @Nullable Tree thenBody, @Nullable Tree elseBody) {
        InstanceOfPatternMatchingCheck.findInstanceOf(condition).ifPresent(instanceOf -> {
            if (!instanceOf.negated && thenBody != null) {
                thenBody.accept((TreeVisitor)new BodyVisitor(instanceOf.tree));
            } else if (instanceOf.negated && elseBody != null) {
                elseBody.accept((TreeVisitor)new BodyVisitor(instanceOf.tree));
            }
        });
    }

    private static Optional<InstanceOfInfo> findInstanceOf(ExpressionTree condition) {
        return InstanceOfPatternMatchingCheck.findInstanceOf(condition, false);
    }

    private static Optional<InstanceOfInfo> findInstanceOf(ExpressionTree condition, boolean negated) {
        condition = ExpressionUtils.skipParentheses((ExpressionTree)condition);
        switch (condition.kind()) {
            case INSTANCE_OF: {
                return Optional.of(new InstanceOfInfo((InstanceOfTree)condition, negated));
            }
            case CONDITIONAL_AND: {
                if (negated) {
                    return Optional.empty();
                }
                return InstanceOfPatternMatchingCheck.findInstanceOfInBinaryExpression(condition, negated);
            }
            case CONDITIONAL_OR: {
                if (!negated) {
                    return Optional.empty();
                }
                return InstanceOfPatternMatchingCheck.findInstanceOfInBinaryExpression(condition, negated);
            }
            case LOGICAL_COMPLEMENT: {
                return InstanceOfPatternMatchingCheck.findInstanceOf(((UnaryExpressionTree)condition).expression(), !negated);
            }
        }
        return Optional.empty();
    }

    private static Optional<InstanceOfInfo> findInstanceOfInBinaryExpression(ExpressionTree condition, boolean negated) {
        BinaryExpressionTree binaryExpression = (BinaryExpressionTree)condition;
        Optional<InstanceOfInfo> leftResult = InstanceOfPatternMatchingCheck.findInstanceOf(binaryExpression.leftOperand(), negated);
        if (leftResult.isPresent()) {
            return leftResult;
        }
        return InstanceOfPatternMatchingCheck.findInstanceOf(binaryExpression.rightOperand(), negated);
    }

    private static class InstanceOfInfo {
        InstanceOfTree tree;
        boolean negated;

        public InstanceOfInfo(InstanceOfTree tree, boolean negated) {
            this.tree = tree;
            this.negated = negated;
        }
    }

    private class BodyVisitor
    extends BaseTreeVisitor {
        InstanceOfTree instanceOf;

        BodyVisitor(InstanceOfTree instanceOf) {
            this.instanceOf = instanceOf;
        }

        public void visitVariable(VariableTree tree) {
            ExpressionTree init;
            Type type = tree.type().symbolType();
            if (!type.isUnknown() && type.equals((Object)this.instanceOf.type().symbolType()) && (init = tree.initializer()) != null && init.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST}) && SyntacticEquivalence.areEquivalentIncludingSameVariables((Tree)((TypeCastTree)init).expression(), (Tree)this.instanceOf.expression())) {
                this.report(this.instanceOf, init, tree.simpleName().name());
                return;
            }
            super.visitVariable(tree);
        }

        public void visitTypeCast(TypeCastTree tree) {
            Type type = tree.symbolType();
            if (!type.isUnknown() && type.equals((Object)this.instanceOf.type().symbolType()) && SyntacticEquivalence.areEquivalentIncludingSameVariables((Tree)tree.expression(), (Tree)this.instanceOf.expression())) {
                this.report(this.instanceOf, (ExpressionTree)tree, tree.type().symbolType().name().toLowerCase(Locale.ROOT));
            }
        }

        private void report(InstanceOfTree instanceOf, ExpressionTree cast, String name) {
            String type = instanceOf.type().symbolType().name();
            String message = String.format("Replace this instanceof check and cast with 'instanceof %s %s'", type, name);
            JavaFileScannerContext.Location secondary = new JavaFileScannerContext.Location("Location of the cast", (Tree)cast);
            InstanceOfPatternMatchingCheck.this.reportIssue((Tree)instanceOf, message, Collections.singletonList(secondary), null);
        }
    }
}

