/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6202")
public class IsInstanceMethodCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Replace this usage of \"%1$s.class.isInstance()\" with \"instanceof %1$s\".";
    private static final MethodMatchers IS_INSTANCE_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.lang.Class"}).names(new String[]{"isInstance"}).withAnyParameters().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
        if (IS_INSTANCE_MATCHER.matches(methodInvocationTree)) {
            ExpressionTree methodSelect = methodInvocationTree.methodSelect();
            if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
                IsInstanceMethodCheck.getClassIdentifier(expression).ifPresent(identifier -> this.reportIssue(tree, String.format(MESSAGE, identifier)));
            }
        }
    }

    private static Optional<String> getClassIdentifier(ExpressionTree expression) {
        MemberSelectExpressionTree memberSelect;
        ExpressionTree originalExpression = ExpressionUtils.skipParentheses((ExpressionTree)expression);
        if (originalExpression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && "class".equals((memberSelect = (MemberSelectExpressionTree)originalExpression).identifier().name())) {
            ExpressionTree selectedExpression = ExpressionUtils.skipParentheses((ExpressionTree)memberSelect.expression());
            return IsInstanceMethodCheck.getName(selectedExpression);
        }
        return Optional.empty();
    }

    private static Optional<String> getName(ExpressionTree selectedExpression) {
        Type type = selectedExpression.symbolType();
        return type.isUnknown() ? Optional.empty() : Optional.of(type.name());
    }
}

