/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3416")
public class LoggerClassCheck
extends IssuableSubscriptionVisitor {
    private static final String CLASS = "java.lang.Class";
    public static final String STRING = "java.lang.String";
    private static final MethodMatchers LOG_FACTORIES = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofAnyType().names(new String[]{"getLogger"}).addParametersMatcher(new String[]{"java.lang.Class"}).addParametersMatcher(new String[]{"java.lang.String"}).build(), MethodMatchers.create().ofTypes(new String[]{"org.apache.commons.logging.LogFactory"}).names(new String[]{"getLog"}).addParametersMatcher(new String[]{"java.lang.Class"}).addParametersMatcher(new String[]{"java.lang.String"}).build(), MethodMatchers.create().ofTypes(new String[]{"org.sonar.api.utils.log.Loggers"}).names(new String[]{"get"}).addParametersMatcher(new String[]{"java.lang.Class"}).addParametersMatcher(new String[]{"java.lang.String"}).build()});
    private static final MethodMatchers CLAZZ_GETNAME = MethodMatchers.create().ofTypes(new String[]{"java.lang.Class"}).names(new String[]{"getName"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        Symbol.TypeSymbol clazz = ((ClassTree)tree).symbol();
        clazz.memberSymbols().stream().filter(Symbol::isVariableSymbol).map(Symbol.VariableSymbol.class::cast).map(Symbol.VariableSymbol::declaration).filter(Objects::nonNull).map(VariableTree::initializer).filter(Objects::nonNull).forEach(initializer -> this.checkField(clazz, (ExpressionTree)initializer));
    }

    private void checkField(Symbol.TypeSymbol clazz, ExpressionTree initializer) {
        ExpressionTree firstArg;
        Symbol classLiteral;
        if (initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && LOG_FACTORIES.matches((MethodInvocationTree)initializer) && (classLiteral = LoggerClassCheck.classLiteral(firstArg = (ExpressionTree)((MethodInvocationTree)initializer).arguments().get(0))) != null && !clazz.type().erasure().equals((Object)classLiteral.type().erasure())) {
            this.reportIssue((Tree)firstArg, "Update this logger to use \"" + clazz.name() + ".class\".");
        }
    }

    @CheckForNull
    private static Symbol classLiteral(ExpressionTree expression) {
        MethodInvocationTree mit;
        MemberSelectExpressionTree mset;
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && "class".equals((mset = (MemberSelectExpressionTree)expression).identifier().name())) {
            return mset.expression().symbolType().symbol();
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && CLAZZ_GETNAME.matches((MethodInvocationTree)expression) && (mit = (MethodInvocationTree)expression).methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return LoggerClassCheck.classLiteral(((MemberSelectExpressionTree)mit.methodSelect()).expression());
        }
        return null;
    }
}

