/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.AbstractPackageInfoChecker;
import org.sonar.plugins.java.api.InputFileScannerContext;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.ModuleScannerContext;

@Rule(key="S1228")
public class MissingPackageInfoCheck
extends AbstractPackageInfoChecker {
    @VisibleForTesting
    final Set<String> missingPackageWithoutPackageFile = new HashSet<String>();
    private final Set<String> knownPackageWithPackageFile = new HashSet<String>();

    @Override
    protected void processFile(InputFileScannerContext context, String packageName) {
        if (this.knownPackageWithPackageFile.contains(packageName)) {
            return;
        }
        File parentFile = context.getInputFile().file().getParentFile();
        if (!new File(parentFile, "package-info.java").isFile()) {
            this.missingPackageWithoutPackageFile.add(packageName);
        } else {
            this.knownPackageWithPackageFile.add(packageName);
        }
    }

    public void endOfAnalysis(ModuleScannerContext context) {
        this.missingPackageWithoutPackageFile.removeAll(this.knownPackageWithPackageFile);
        for (String missingPackageInfo : this.missingPackageWithoutPackageFile) {
            context.addIssueOnProject((JavaCheck)this, "Add a 'package-info.java' file to document the '" + missingPackageInfo + "' package");
        }
    }
}

