/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

@Rule(key="S2245")
public class PseudoRandomCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Make sure that using this pseudorandom number generator is safe here.";
    private static final MethodMatchers STATIC_RANDOM_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.lang.Math"}).names(new String[]{"random"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.util.concurrent.ThreadLocalRandom", "org.apache.commons.lang.math.RandomUtils", "org.apache.commons.lang3.RandomUtils", "org.apache.commons.lang.RandomStringUtils", "org.apache.commons.lang3.RandomStringUtils"}).anyName().withAnyParameters().build()});
    private static final MethodMatchers RANDOM_STRING_UTILS_RANDOM_WITH_RANDOM_SOURCE = MethodMatchers.create().ofSubTypes(new String[]{"org.apache.commons.lang.RandomStringUtils", "org.apache.commons.lang3.RandomStringUtils"}).names(new String[]{"random"}).addParametersMatcher(new String[]{"int", "int", "int", "boolean", "boolean", "char[]", "java.util.Random"}).build();
    private static final Set<String> RANDOM_CONSTRUCTOR_TYPES = SetUtils.immutableSetOf((Object[])new String[]{"java.util.Random", "org.apache.commons.lang.math.JVMRandom"});

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.NEW_CLASS, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            IdentifierTree reportLocation = ExpressionUtils.methodName((MethodInvocationTree)mit);
            if (PseudoRandomCheck.isStaticCallToInsecureRandomMethod(mit)) {
                this.reportIssue((Tree)reportLocation, MESSAGE);
            }
        } else {
            NewClassTree newClass = (NewClassTree)tree;
            if (RANDOM_CONSTRUCTOR_TYPES.contains(newClass.symbolType().fullyQualifiedName())) {
                this.reportIssue((Tree)newClass.identifier(), MESSAGE);
            }
        }
    }

    private static boolean isStaticCallToInsecureRandomMethod(MethodInvocationTree mit) {
        return STATIC_RANDOM_METHODS.matches(mit) && !RANDOM_STRING_UTILS_RANDOM_WITH_RANDOM_SOURCE.matches(mit) && mit.methodSymbol().isStatic();
    }
}

