/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6206")
public class RecordInsteadOfClassCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava16Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        Map<String, Type> fieldsNameToType;
        ClassTree classTree = (ClassTree)tree;
        if (classTree.superClass() != null) {
            return;
        }
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        if (classSymbol.isAbstract()) {
            return;
        }
        if (!classSymbol.isFinal()) {
            return;
        }
        List<Symbol.VariableSymbol> fields = RecordInsteadOfClassCheck.classFields(classSymbol);
        if (fields.isEmpty() || !RecordInsteadOfClassCheck.hasOnlyPrivateFinalFields(fields)) {
            return;
        }
        List<Symbol.MethodSymbol> methods = RecordInsteadOfClassCheck.classMethods(classSymbol);
        if (!RecordInsteadOfClassCheck.hasGetterForEveryField(methods, fieldsNameToType = fields.stream().collect(Collectors.toMap(Symbol::name, Symbol::type)))) {
            return;
        }
        List<Symbol.MethodSymbol> constructors = RecordInsteadOfClassCheck.classConstructors(methods);
        if (constructors.size() != 1) {
            return;
        }
        Symbol.MethodSymbol constructor = constructors.get(0);
        if (RecordInsteadOfClassCheck.hasParameterForEveryField(constructor, fieldsNameToType.keySet()) && !RecordInsteadOfClassCheck.constructorHasSmallerVisibility(constructor, classSymbol)) {
            this.reportIssue((Tree)classTree.simpleName(), String.format("Refactor this class declaration to use 'record %s'.", RecordInsteadOfClassCheck.recordName(classTree, constructor)));
        }
    }

    private static boolean constructorHasSmallerVisibility(Symbol.MethodSymbol constructor, Symbol.TypeSymbol classSymbol) {
        boolean constructorIsPrivate = constructor.isPrivate();
        boolean constructorIsPackageVisibility = constructor.isPackageVisibility();
        if (classSymbol.isPublic()) {
            return constructorIsPrivate || constructorIsPackageVisibility || constructor.isProtected();
        }
        if (classSymbol.isProtected()) {
            return constructorIsPrivate || constructorIsPackageVisibility;
        }
        if (classSymbol.isPackageVisibility()) {
            return constructorIsPrivate;
        }
        return false;
    }

    private static List<Symbol.MethodSymbol> classMethods(Symbol.TypeSymbol classSymbol) {
        return classSymbol.memberSymbols().stream().filter(Symbol::isMethodSymbol).map(Symbol.MethodSymbol.class::cast).collect(Collectors.toList());
    }

    private static List<Symbol.VariableSymbol> classFields(Symbol.TypeSymbol classSymbol) {
        return classSymbol.memberSymbols().stream().filter(Symbol::isVariableSymbol).filter(s -> !RecordInsteadOfClassCheck.isConstant(s)).map(Symbol.VariableSymbol.class::cast).collect(Collectors.toList());
    }

    private static List<Symbol.MethodSymbol> classConstructors(List<Symbol.MethodSymbol> methods) {
        return methods.stream().filter(m -> "<init>".equals(m.name())).filter(m -> m.declaration() != null).collect(Collectors.toList());
    }

    private static boolean hasOnlyPrivateFinalFields(List<Symbol.VariableSymbol> fields) {
        return fields.stream().allMatch(RecordInsteadOfClassCheck::isPrivateFinal);
    }

    private static boolean isConstant(Symbol symbol) {
        return symbol.isStatic() && symbol.isFinal();
    }

    private static boolean isPrivateFinal(Symbol symbol) {
        return symbol.isPrivate() && symbol.isFinal();
    }

    private static boolean hasGetterForEveryField(List<Symbol.MethodSymbol> methods, Map<String, Type> fieldsNameToType) {
        Set gettersForField = methods.stream().filter(m -> RecordInsteadOfClassCheck.isGetter(m, fieldsNameToType)).map(Symbol::name).map(RecordInsteadOfClassCheck::toFieldName).collect(Collectors.toSet());
        return gettersForField.containsAll(fieldsNameToType.keySet());
    }

    private static boolean isGetter(Symbol.MethodSymbol method, Map<String, Type> fieldsNameToType) {
        String methodName = method.name();
        if (!method.parameterTypes().isEmpty()) {
            return false;
        }
        if (RecordInsteadOfClassCheck.matchNameAndType(methodName, method, fieldsNameToType)) {
            return true;
        }
        if ("get".equals(methodName) || "is".equals(methodName)) {
            return false;
        }
        return (methodName.startsWith("get") || methodName.startsWith("is")) && RecordInsteadOfClassCheck.matchNameAndType(RecordInsteadOfClassCheck.toFieldName(methodName), method, fieldsNameToType);
    }

    private static boolean matchNameAndType(String methodName, Symbol.MethodSymbol method, Map<String, Type> fieldsNameToType) {
        return method.returnType().type().equals((Object)fieldsNameToType.get(methodName));
    }

    private static String toFieldName(String methodName) {
        if (methodName.startsWith("is")) {
            return RecordInsteadOfClassCheck.lowerCaseFirstLetter(methodName.substring(2));
        }
        if (methodName.startsWith("get")) {
            return RecordInsteadOfClassCheck.lowerCaseFirstLetter(methodName.substring(3));
        }
        return methodName;
    }

    private static String lowerCaseFirstLetter(String methodName) {
        return Character.toLowerCase(methodName.charAt(0)) + methodName.substring(1);
    }

    private static boolean hasParameterForEveryField(Symbol.MethodSymbol constructor, Set<String> fieldNames) {
        Set parameterNames = constructor.declaration().parameters().stream().map(VariableTree::simpleName).map(IdentifierTree::name).collect(Collectors.toSet());
        return parameterNames.equals(fieldNames);
    }

    private static String recordName(ClassTree classTree, Symbol.MethodSymbol constructor) {
        String typeName = classTree.simpleName().name();
        return String.format("%s(%s)", typeName, RecordInsteadOfClassCheck.parametersAsString(constructor.declaration().parameters()));
    }

    private static String parametersAsString(List<VariableTree> parameters) {
        String parametersAsString = parameters.stream().map(p -> String.format("%s %s", RecordInsteadOfClassCheck.typeAsString(p.type()), p.simpleName().name())).collect(Collectors.joining(", "));
        if (parametersAsString.length() > 50) {
            return parametersAsString.substring(0, 47) + "...";
        }
        return parametersAsString;
    }

    private static String typeAsString(TypeTree type) {
        switch (type.kind()) {
            case PARAMETERIZED_TYPE: {
                return RecordInsteadOfClassCheck.typeAsString(((ParameterizedTypeTree)type).type()) + "<...>";
            }
            case IDENTIFIER: {
                return ((IdentifierTree)type).name();
            }
            case ARRAY_TYPE: {
                ArrayTypeTree arrayTypeTree = (ArrayTypeTree)type;
                String arrayText = arrayTypeTree.ellipsisToken() != null ? " ..." : "[]";
                return RecordInsteadOfClassCheck.typeAsString(arrayTypeTree.type()) + arrayText;
            }
            case PRIMITIVE_TYPE: {
                return ((PrimitiveTypeTree)type).keyword().text();
            }
            case MEMBER_SELECT: {
                return RecordInsteadOfClassCheck.typeAsString((TypeTree)((MemberSelectExpressionTree)type).identifier());
            }
        }
        return "?";
    }
}

