/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3038")
public class RedundantAbstractMethodCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        Symbol.MethodSymbol method = ((MethodTree)tree).symbol();
        if (method.isAbstract() && method.owner().isAbstract()) {
            this.checkMethod(method);
        }
    }

    private void checkMethod(Symbol.MethodSymbol method) {
        List overridees = method.overriddenSymbols();
        if (overridees.isEmpty()) {
            return;
        }
        Symbol.MethodSymbol overridee = (Symbol.MethodSymbol)overridees.get(0);
        if (!overridees.isEmpty() && overridee.owner().isInterface() && !RedundantAbstractMethodCheck.differentContract(method, overridee)) {
            this.reportIssue((Tree)method.declaration(), "\"" + method.name() + "\" is defined in the \"" + overridee.owner().name() + "\" interface and can be removed from this class.");
        }
    }

    private static boolean differentContract(Symbol.MethodSymbol method, Symbol.MethodSymbol overridee) {
        return RedundantAbstractMethodCheck.removingParametrizedAspect(method, overridee) || RedundantAbstractMethodCheck.differentThrows(method, overridee) || RedundantAbstractMethodCheck.differentReturnType(method, overridee) || RedundantAbstractMethodCheck.differentParameters(method, overridee) || RedundantAbstractMethodCheck.differentAnnotations(method.metadata(), overridee.metadata());
    }

    private static boolean removingParametrizedAspect(Symbol.MethodSymbol method, Symbol.MethodSymbol overridee) {
        return !JUtils.isParametrizedMethod((Symbol.MethodSymbol)method) && JUtils.isParametrizedMethod((Symbol.MethodSymbol)overridee);
    }

    private static boolean differentThrows(Symbol.MethodSymbol method, Symbol.MethodSymbol overridee) {
        return !new HashSet(method.thrownTypes()).equals(new HashSet(overridee.thrownTypes()));
    }

    private static boolean differentReturnType(Symbol.MethodSymbol method, Symbol.MethodSymbol overridee) {
        Type methodResultType = RedundantAbstractMethodCheck.resultType(method);
        Type overrideeResultType = RedundantAbstractMethodCheck.resultType(overridee);
        return RedundantAbstractMethodCheck.specializationOfReturnType(methodResultType.erasure(), overrideeResultType.erasure()) || RedundantAbstractMethodCheck.useRawTypeOfParametrizedType(methodResultType, overrideeResultType);
    }

    private static Type resultType(Symbol.MethodSymbol method) {
        return method.returnType().type();
    }

    private static boolean specializationOfReturnType(Type methodResultType, Type overrideeResultType) {
        return !methodResultType.isVoid() && methodResultType.isSubtypeOf(overrideeResultType) && !overrideeResultType.isSubtypeOf(methodResultType);
    }

    private static boolean differentParameters(Symbol.MethodSymbol method, Symbol.MethodSymbol overridee) {
        return RedundantAbstractMethodCheck.useRawTypeOfParametrizedType(method.parameterTypes(), overridee.parameterTypes()) || RedundantAbstractMethodCheck.differentAnnotationsOnParameters(method, overridee);
    }

    private static boolean useRawTypeOfParametrizedType(List<Type> methodParamTypes, List<Type> overrideeParamType) {
        for (int i = 0; i < methodParamTypes.size(); ++i) {
            if (!RedundantAbstractMethodCheck.useRawTypeOfParametrizedType(methodParamTypes.get(i), overrideeParamType.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean useRawTypeOfParametrizedType(Type methodParam, Type overrideeParam) {
        return !methodParam.isParameterized() && overrideeParam.isParameterized() && methodParam.erasure().equals((Object)overrideeParam.erasure());
    }

    private static boolean differentAnnotationsOnParameters(Symbol.MethodSymbol method, Symbol.MethodSymbol overridee) {
        for (int i = 0; i < method.parameterTypes().size(); ++i) {
            if (!RedundantAbstractMethodCheck.differentAnnotations(JUtils.parameterAnnotations((Symbol.MethodSymbol)method, (int)i), JUtils.parameterAnnotations((Symbol.MethodSymbol)overridee, (int)i))) continue;
            return true;
        }
        return false;
    }

    private static boolean differentAnnotations(SymbolMetadata methodMetadata, SymbolMetadata overrideeMetadata) {
        for (SymbolMetadata.AnnotationInstance annotation : methodMetadata.annotations()) {
            Type type = annotation.symbol().type();
            if (type.is("java.lang.Override") || overrideeMetadata.isAnnotatedWith(type.fullyQualifiedName())) continue;
            return true;
        }
        return false;
    }
}

