/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4635")
public class StringOffsetMethodsCheck
extends AbstractMethodDetection {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String INT = "int";
    private static final MethodMatchers SUBSTRING = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"substring"}).addParametersMatcher(new String[]{"int"}).build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{JAVA_LANG_STRING}).names(new String[]{"indexOf", "lastIndexOf"}).addParametersMatcher(new String[]{INT}).build(), MethodMatchers.create().ofTypes(new String[]{JAVA_LANG_STRING}).names(new String[]{"indexOf", "lastIndexOf", "startsWith"}).addParametersMatcher(new String[]{JAVA_LANG_STRING}).build()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree expression;
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (expression = ((MemberSelectExpressionTree)methodSelect).expression()).is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && SUBSTRING.matches((Symbol)((MethodInvocationTree)expression).methodSymbol())) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)((MethodInvocationTree)expression)), (Tree)mit, String.format("Replace \"%s\" with the overload that accepts an offset parameter.", mit.methodSymbol().name()));
        }
    }
}

