/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="SwitchLastCaseIsDefaultCheck", repositoryKey="squid")
@Rule(key="S131")
public class SwitchLastCaseIsDefaultCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_LABEL_STRING = JavaKeyword.DEFAULT.getValue();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
        if (SwitchLastCaseIsDefaultCheck.getDefaultLabel(switchStatementTree)) {
            if (!SwitchLastCaseIsDefaultCheck.isSwitchOnEnum(switchStatementTree)) {
                this.reportIssue((Tree)switchStatementTree.switchKeyword(), "Add a default case to this switch.");
            } else if (SwitchLastCaseIsDefaultCheck.missingCasesOfEnum(switchStatementTree)) {
                this.reportIssue((Tree)switchStatementTree.switchKeyword(), "Complete cases by adding the missing enum constants or add a default case to this switch.");
            }
        }
    }

    private static boolean getDefaultLabel(SwitchStatementTree switchStatementTree) {
        return SwitchLastCaseIsDefaultCheck.allLabels(switchStatementTree).noneMatch(SwitchLastCaseIsDefaultCheck::isDefault);
    }

    private static boolean isDefault(CaseLabelTree caseLabelTree) {
        if (SwitchLastCaseIsDefaultCheck.equalsDefaultKeyword(caseLabelTree.caseOrDefaultKeyword().text())) {
            return true;
        }
        return caseLabelTree.expressions().stream().anyMatch(expr -> expr.is(new Tree.Kind[]{Tree.Kind.DEFAULT_PATTERN}));
    }

    private static boolean equalsDefaultKeyword(String text) {
        return DEFAULT_LABEL_STRING.equals(text);
    }

    private static boolean isSwitchOnEnum(SwitchStatementTree switchStatementTree) {
        Symbol.TypeSymbol symbol = switchStatementTree.expression().symbolType().symbol();
        return symbol.isEnum() || symbol.isUnknown();
    }

    private static boolean missingCasesOfEnum(SwitchStatementTree switchStatementTree) {
        return SwitchLastCaseIsDefaultCheck.numberConstants(switchStatementTree) > SwitchLastCaseIsDefaultCheck.allExpressions(switchStatementTree).count();
    }

    private static Stream<CaseLabelTree> allLabels(SwitchStatementTree switchStatementTree) {
        return switchStatementTree.cases().stream().flatMap(caseGroup -> caseGroup.labels().stream());
    }

    private static Stream<ExpressionTree> allExpressions(SwitchStatementTree switchStatementTree) {
        return SwitchLastCaseIsDefaultCheck.allLabels(switchStatementTree).flatMap(caseLabel -> caseLabel.expressions().stream());
    }

    private static long numberConstants(SwitchStatementTree switchStatementTree) {
        return switchStatementTree.expression().symbolType().symbol().memberSymbols().stream().filter(Symbol::isVariableSymbol).filter(Symbol::isEnum).count();
    }
}

