/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

public final class Javadoc {
    private static final Tree.Kind[] CLASS_KINDS = PublicApiChecker.classKinds();
    private static final Tree.Kind[] METHOD_KINDS = PublicApiChecker.methodKinds();
    private static final Set<String> GENERIC_EXCEPTIONS = SetUtils.immutableSetOf((Object[])new String[]{"Exception", "java.lang.Exception"});
    private static final Set<String> PLACEHOLDERS = SetUtils.immutableSetOf((Object[])new String[]{"TODO", "FIXME", "...", "."});
    private final List<String> elementParameters;
    private final List<String> elementExceptionNames;
    private final String mainDescription;
    private final Map<BlockTagKey, List<String>> blockTagDescriptions;
    private final EnumMap<BlockTag, List<String>> undocumentedNamedTags;

    public Javadoc(Tree tree) {
        if (tree.is(METHOD_KINDS)) {
            this.elementParameters = ((MethodTree)tree).parameters().stream().map(VariableTree::simpleName).map(IdentifierTree::name).collect(Collectors.toList());
            this.elementExceptionNames = ((MethodTree)tree).throwsClauses().stream().map(Javadoc::exceptionName).filter(Objects::nonNull).collect(Collectors.toList());
        } else if (tree.is(CLASS_KINDS)) {
            this.elementParameters = ((ClassTree)tree).typeParameters().stream().map(TypeParameterTree::identifier).map(IdentifierTree::name).map(name -> "<" + name + ">").collect(Collectors.toList());
            this.elementExceptionNames = Collections.emptyList();
        } else {
            this.elementParameters = Collections.emptyList();
            this.elementExceptionNames = Collections.emptyList();
        }
        List<String> javadocLines = Javadoc.cleanLines(PublicApiChecker.getApiJavadoc((Tree)tree).orElse(""));
        this.mainDescription = Javadoc.getDescription(javadocLines, -1, "");
        this.blockTagDescriptions = Javadoc.extractBlockTags(javadocLines, Arrays.asList(BlockTag.values()));
        this.undocumentedNamedTags = new EnumMap(BlockTag.class);
    }

    public boolean noMainDescription() {
        return Javadoc.isEmptyDescription(this.mainDescription);
    }

    public boolean noReturnDescription() {
        return Javadoc.isEmptyDescription(this.blockTagDescriptions.get(BlockTagKey.of(BlockTag.RETURN, null)));
    }

    public Set<String> undocumentedParameters() {
        return new LinkedHashSet<String>(this.undocumentedNamedTags.computeIfAbsent(BlockTag.PARAM, key -> this.computeUndocumentedParameters()));
    }

    public Set<String> undocumentedThrownExceptions() {
        return new LinkedHashSet<String>(this.undocumentedNamedTags.computeIfAbsent(BlockTag.EXCEPTIONS, key -> this.computeUndocumentedThrownExceptions()));
    }

    private List<String> computeUndocumentedParameters() {
        return this.elementParameters.stream().filter(name -> Javadoc.isEmptyDescription(this.blockTagDescriptions.get(BlockTagKey.of(BlockTag.PARAM, name)))).collect(Collectors.toList());
    }

    private List<String> computeUndocumentedThrownExceptions() {
        Map<String, List> thrownExceptionsMap = this.blockTagDescriptions.entrySet().stream().filter(entry -> ((BlockTagKey)entry.getKey()).tag == BlockTag.EXCEPTIONS && ((BlockTagKey)entry.getKey()).name != null).collect(Collectors.toMap(entry -> ((BlockTagKey)entry.getKey()).name, Map.Entry::getValue));
        List<String> exceptionNames = this.elementExceptionNames;
        if (exceptionNames.size() == 1 && GENERIC_EXCEPTIONS.contains(Javadoc.toSimpleName(exceptionNames.get(0))) && !thrownExceptionsMap.isEmpty()) {
            return thrownExceptionsMap.entrySet().stream().filter(e -> Javadoc.isEmptyDescription((List)e.getValue())).map(Map.Entry::getKey).map(Javadoc::toSimpleName).collect(Collectors.toList());
        }
        return exceptionNames.stream().map(Javadoc::toSimpleName).filter(simpleName -> Javadoc.noDescriptionForException(thrownExceptionsMap, simpleName)).collect(Collectors.toList());
    }

    private static boolean noDescriptionForException(Map<String, List<String>> thrownExceptionsMap, String exceptionSimpleName) {
        List<String> descriptions = thrownExceptionsMap.get(exceptionSimpleName);
        if (descriptions == null) {
            descriptions = thrownExceptionsMap.entrySet().stream().filter(e -> Javadoc.toSimpleName((String)e.getKey()).equals(exceptionSimpleName)).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return Javadoc.isEmptyDescription(descriptions);
    }

    private static Map<BlockTagKey, List<String>> extractBlockTags(List<String> javadocLines, List<BlockTag> tags) {
        HashMap<BlockTagKey, List<String>> results = new HashMap<BlockTagKey, List<String>>();
        block0: for (int i = 0; i < javadocLines.size(); ++i) {
            for (int j = 0; j < tags.size(); ++j) {
                BlockTag tag = tags.get(j);
                Matcher matcher = tag.getPattern().matcher(javadocLines.get(i));
                if (!matcher.matches()) continue;
                BlockTagKey key = BlockTagKey.of(tag, tag.isPatternWithName() ? matcher.group("name") : null);
                List descriptions = results.computeIfAbsent(key, k -> new ArrayList());
                String newDescription = Javadoc.getDescription(javadocLines, i, matcher.group("descr"));
                if (newDescription.isEmpty()) continue;
                descriptions.add(newDescription);
                continue block0;
            }
        }
        return results;
    }

    private static String toSimpleName(String exceptionName) {
        int lastDot = exceptionName.lastIndexOf(46);
        if (lastDot != -1) {
            return exceptionName.substring(lastDot + 1);
        }
        return exceptionName;
    }

    private static boolean isEmptyDescription(@Nullable List<String> descriptions) {
        return descriptions == null || descriptions.isEmpty() || descriptions.stream().anyMatch(Javadoc::isEmptyDescription);
    }

    private static boolean isEmptyDescription(String part) {
        return part.trim().isEmpty() || PLACEHOLDERS.contains(part.trim());
    }

    @CheckForNull
    private static String exceptionName(TypeTree typeTree) {
        switch (typeTree.kind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)typeTree).name();
            }
            case MEMBER_SELECT: {
                return ExpressionsHelper.concatenate((ExpressionTree)((MemberSelectExpressionTree)typeTree));
            }
        }
        return null;
    }

    private static List<String> cleanLines(@Nullable String javadoc) {
        if (javadoc == null) {
            return Collections.emptyList();
        }
        String trimmedJavadoc = javadoc.trim();
        if (trimmedJavadoc.length() <= 4) {
            return Collections.emptyList();
        }
        String[] lines = trimmedJavadoc.substring(3, trimmedJavadoc.length() - 2).replaceAll("(?m)^\\s*\\*", "").trim().split("\\r?\\n");
        return Arrays.stream(lines).map(String::trim).collect(Collectors.toList());
    }

    private static String getDescription(List<String> lines, int lineIndex, @Nullable String currentValue) {
        StringBuilder sb = new StringBuilder();
        sb.append(currentValue != null ? currentValue : "");
        int currentIndex = lineIndex;
        while (currentIndex + 1 < lines.size() && !lines.get(currentIndex + 1).startsWith("@")) {
            sb.append(" ");
            sb.append(lines.get(currentIndex + 1));
            ++currentIndex;
        }
        return sb.toString().trim();
    }

    @VisibleForTesting
    String getMainDescription() {
        return this.mainDescription;
    }

    @VisibleForTesting
    Map<BlockTagKey, List<String>> getBlockTagDescriptions() {
        return this.blockTagDescriptions;
    }

    private static enum BlockTag {
        RETURN(Pattern.compile("^@return(\\s++)?(?<descr>.+)?"), false),
        PARAM(Pattern.compile("^@param\\s++(?<name>\\S*)(\\s++)?(?<descr>.+)?"), true),
        EXCEPTIONS(Pattern.compile("^(?:@throws|@exception)\\s++(?<name>\\S*)(\\s++)?(?<descr>.+)?"), true);

        private final Pattern pattern;
        private final boolean patternWithName;

        private BlockTag(Pattern pattern, boolean patternWithName) {
            this.pattern = pattern;
            this.patternWithName = patternWithName;
        }

        private Pattern getPattern() {
            return this.pattern;
        }

        private boolean isPatternWithName() {
            return this.patternWithName;
        }
    }

    private static class BlockTagKey {
        private final BlockTag tag;
        private final String name;

        BlockTagKey(BlockTag tag, @Nullable String name) {
            this.tag = tag;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof BlockTagKey) {
                BlockTagKey other = (BlockTagKey)o;
                return this.tag == other.tag && Objects.equals(this.name, other.name);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.tag, this.name});
        }

        private static BlockTagKey of(BlockTag tag, @Nullable String name) {
            return new BlockTagKey(tag, name);
        }
    }
}

