/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.BoundaryTree;
import org.sonarsource.analyzer.commons.regex.ast.NonCapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;

@Rule(key="S5846")
public class EmptyLineRegexCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Remove MULTILINE mode or change the regex.";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_UTIL_PATTERN = "java.util.regex.Pattern";
    private static final MethodMatchers STRING_REPLACE = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"replaceAll", "replaceFirst"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.String"}).build();
    private static final MethodMatchers PATTERN_COMPILE = MethodMatchers.create().ofTypes(new String[]{"java.util.regex.Pattern"}).names(new String[]{"compile"}).addParametersMatcher(new String[]{"java.lang.String"}).addParametersMatcher(new String[]{"java.lang.String", "int"}).build();
    private static final MethodMatchers PATTERN_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.util.regex.Pattern"}).names(new String[]{"matcher"}).addParametersMatcher(new String[]{"java.lang.CharSequence"}).build();
    private static final MethodMatchers PATTERN_FIND = MethodMatchers.create().ofTypes(new String[]{"java.util.regex.Matcher"}).names(new String[]{"find"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers STRING_IS_EMPTY = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"isEmpty"}).addWithoutParametersMatcher().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{STRING_REPLACE, PATTERN_COMPILE});
    }

    @Override
    protected boolean filterAnnotation(AnnotationTree annotation) {
        return false;
    }

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        MethodInvocationTree mit = (MethodInvocationTree)methodInvocationOrAnnotation;
        EmptyLineMultilineVisitor visitor = new EmptyLineMultilineVisitor();
        visitor.visit(regexForLiterals);
        if (visitor.containEmptyLine) {
            if (PATTERN_COMPILE.matches(mit)) {
                List<Tree> stringNotTestedForEmpty = EmptyLineRegexCheck.getStringNotTestedForEmpty(mit);
                if (!stringNotTestedForEmpty.isEmpty()) {
                    this.reportWithSecondaries((Tree)mit.arguments().get(0), stringNotTestedForEmpty);
                }
            } else {
                ExpressionTree methodSelect = mit.methodSelect();
                if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && EmptyLineRegexCheck.canBeEmpty((Tree)((MemberSelectExpressionTree)methodSelect).expression())) {
                    this.reportIssue((Tree)mit.arguments().get(0), MESSAGE);
                }
            }
        }
    }

    private static List<Tree> getStringNotTestedForEmpty(MethodInvocationTree mit) {
        Tree parent = mit.parent();
        if (parent != null && parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return ((VariableTree)parent).symbol().usages().stream().map(EmptyLineRegexCheck::getStringInMatcherFind).filter(Optional::isPresent).map(Optional::get).filter(EmptyLineRegexCheck::canBeEmpty).collect(Collectors.toList());
        }
        return EmptyLineRegexCheck.getStringInMatcherFind((ExpressionTree)mit).filter(EmptyLineRegexCheck::canBeEmpty).map(Collections::singletonList).orElseGet(Collections::emptyList);
    }

    private static Optional<Tree> getStringInMatcherFind(ExpressionTree mit) {
        return MethodTreeUtils.subsequentMethodInvocation((Tree)mit, PATTERN_MATCHER).filter(matcherMit -> MethodTreeUtils.subsequentMethodInvocation((Tree)matcherMit, PATTERN_FIND).isPresent()).map(matcherMit -> (Tree)matcherMit.arguments().get(0));
    }

    private static boolean canBeEmpty(Tree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol identifierSymbol = ((IdentifierTree)expressionTree).symbol();
            Symbol owner = identifierSymbol.owner();
            return owner != null && owner.isMethodSymbol() && identifierSymbol.usages().stream().noneMatch(EmptyLineRegexCheck::isIsEmpty);
        }
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.TEXT_BLOCK})) {
            return LiteralUtils.trimQuotes((String)((LiteralTree)expressionTree).value()).isEmpty();
        }
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            return EmptyLineRegexCheck.canBeEmpty((Tree)((ParenthesizedTree)expressionTree).expression());
        }
        return false;
    }

    private static boolean isIsEmpty(IdentifierTree id) {
        return MethodTreeUtils.subsequentMethodInvocation((Tree)id, STRING_IS_EMPTY).isPresent();
    }

    private void reportWithSecondaries(Tree regex, List<Tree> secondaries) {
        List secondariesLocation = secondaries.stream().map(secondary -> new JavaFileScannerContext.Location("This string can be empty.", secondary)).collect(Collectors.toList());
        this.reportIssue(regex, MESSAGE, secondariesLocation, null);
    }

    private static class EmptyLineMultilineVisitor
    extends RegexBaseVisitor {
        boolean visitedStart = false;
        boolean visitedEndAfterStart = false;
        boolean containEmptyLine = false;

        private EmptyLineMultilineVisitor() {
        }

        public void visitSequence(SequenceTree tree) {
            List items = tree.getItems().stream().filter(item -> !EmptyLineMultilineVisitor.isNonCapturingWithoutChild(item)).collect(Collectors.toList());
            if (items.size() == 1 && ((RegexTree)items.get(0)).is(new RegexTree.Kind[]{RegexTree.Kind.CAPTURING_GROUP})) {
                super.visitSequence(tree);
            } else if (items.size() == 2 && ((RegexTree)items.get(0)).is(new RegexTree.Kind[]{RegexTree.Kind.BOUNDARY}) && ((RegexTree)items.get(1)).is(new RegexTree.Kind[]{RegexTree.Kind.BOUNDARY})) {
                super.visitSequence(tree);
                this.containEmptyLine |= this.visitedEndAfterStart;
            }
            this.visitedStart = false;
        }

        public void visitBoundary(BoundaryTree boundaryTree) {
            if (boundaryTree.activeFlags().contains(8)) {
                if (boundaryTree.type().equals((Object)BoundaryTree.Type.LINE_START)) {
                    this.visitedStart = true;
                } else if (boundaryTree.type().equals((Object)BoundaryTree.Type.LINE_END)) {
                    this.visitedEndAfterStart = this.visitedStart;
                }
            }
        }

        private static boolean isNonCapturingWithoutChild(RegexTree tree) {
            return tree.is(new RegexTree.Kind[]{RegexTree.Kind.NON_CAPTURING_GROUP}) && ((NonCapturingGroupTree)tree).getElement() == null;
        }
    }
}

